/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        Scope retVal = Scope.PACKAGE;
        for (DetailAST token = aMods.getFirstChild(); token != null; token = token.getNextSibling()) {
            if ("public".equals(token.getText())) {
                retVal = Scope.PUBLIC;
                break;
            }
            if ("protected".equals(token.getText())) {
                retVal = Scope.PROTECTED;
                break;
            }
            if (!"private".equals(token.getText())) continue;
            retVal = Scope.PRIVATE;
            break;
        }
        return retVal;
    }

    public static Scope getSurroundingScope(DetailAST aAST) {
        Scope retVal = null;
        for (DetailAST token = aAST.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type == 14 || type == 15 || type == 157 || type == 154) {
                DetailAST mods = token.findFirstToken(5);
                Scope modScope = ScopeUtils.getScopeFromMods(mods);
                if (retVal != null && !retVal.isIn(modScope)) continue;
                retVal = modScope;
                continue;
            }
            if (type != 136) continue;
            retVal = Scope.ANONINNER;
            break;
        }
        return retVal;
    }

    public static boolean inInterfaceBlock(DetailAST aAST) {
        int type;
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && (type = token.getType()) != 14 && type != 154 && type != 157 && type != 136; token = token.getParent()) {
            if (type != 15) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static boolean inAnnotationBlock(DetailAST aAST) {
        int type;
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && (type = token.getType()) != 14 && type != 154 && type != 15 && type != 136; token = token.getParent()) {
            if (type != 157) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static boolean inInterfaceOrAnnotationBlock(DetailAST aAST) {
        return ScopeUtils.inInterfaceBlock(aAST) || ScopeUtils.inAnnotationBlock(aAST);
    }

    public static boolean inEnumBlock(DetailAST aAST) {
        int type;
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && (type = token.getType()) != 15 && type != 157 && type != 14 && type != 136; token = token.getParent()) {
            if (type != 154) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static boolean inCodeBlock(DetailAST aAST) {
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type != 9 && type != 8 && type != 11 && type != 12) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static boolean isOuterMostType(DetailAST aAST) {
        boolean retVal = true;
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 14 && parent.getType() != 15 && parent.getType() != 157 && parent.getType() != 154) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public static boolean isLocalVariableDef(DetailAST aAST) {
        DetailAST parent;
        if (aAST.getType() == 10) {
            DetailAST parent2 = aAST.getParent();
            if (parent2 != null) {
                int type = parent2.getType();
                return type == 7 || type == 35 || type == 156;
            }
        } else if (aAST.getType() == 21 && (parent = aAST.getParent()) != null) {
            return parent.getType() == 96;
        }
        return false;
    }
}

