/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;

public class InnerAssignmentCheck
extends Check {
    public static final String MSG_KEY = "assignment.inner.avoid";
    private static final int[][] ALLOWED_ASSIGNMENT_CONTEXT = new int[][]{{28, 7}, {10}, {28, 34, 35}, {28, 34, 37}, {160}, {178, 177, 176}, {28, 181}};
    private static final int[][] CONTROL_CONTEXT = new int[][]{{28, 85}, {28, 91}, {28, 84}, {28, 83}, {28, 92}};
    private static final int[][] ALLOWED_ASSIGNMENT_IN_COMPARISON_CONTEXT = new int[][]{{28, 84}};
    private static final int[] COMPARISON_TYPES = new int[]{116, 120, 118, 119, 117, 115};

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!(InnerAssignmentCheck.isInContext(ast, ALLOWED_ASSIGNMENT_CONTEXT) || InnerAssignmentCheck.isInNoBraceControlStatement(ast) || InnerAssignmentCheck.isInWhileIdiom(ast))) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isInNoBraceControlStatement(DetailAST ast) {
        if (!InnerAssignmentCheck.isInContext(ast, CONTROL_CONTEXT)) {
            return false;
        }
        DetailAST expr = ast.getParent();
        DetailAST exprNext = expr.getNextSibling();
        return exprNext.getType() == 45;
    }

    private static boolean isInWhileIdiom(DetailAST ast) {
        if (!InnerAssignmentCheck.isComparison(ast.getParent())) {
            return false;
        }
        return InnerAssignmentCheck.isInContext(ast.getParent(), ALLOWED_ASSIGNMENT_IN_COMPARISON_CONTEXT);
    }

    private static boolean isComparison(DetailAST ast) {
        int astType = ast.getType();
        return Arrays.binarySearch(COMPARISON_TYPES, astType) >= 0;
    }

    private static boolean isInContext(DetailAST ast, int[] ... contextSet) {
        boolean found = false;
        for (int[] element : contextSet) {
            DetailAST current = ast;
            for (int anElement : element) {
                if ((current = current.getParent()).getType() != anElement) {
                    found = false;
                    break;
                }
                found = true;
            }
            if (found) break;
        }
        return found;
    }

    static {
        Arrays.sort(COMPARISON_TYPES);
    }
}

