/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.ImmutableSet;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractDeclarationCollector;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class RequireThisCheck
extends AbstractDeclarationCollector {
    public static final String MSG_METHOD = "require.this.method";
    public static final String MSG_VARIABLE = "require.this.variable";
    private static final ImmutableSet<Integer> DECLARATION_TOKENS = ImmutableSet.of((Object)10, (Object)8, (Object)9, (Object)14, (Object)154, (Object)15, (Object[])new Integer[]{21, 164});
    private boolean checkFields = true;
    private boolean checkMethods = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 8, 9, 7, 58};
    }

    @Override
    public void visitToken(DetailAST ast) {
        super.visitToken(ast);
        if (ast.getType() == 58) {
            this.processIdent(ast);
        }
    }

    private void processIdent(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 159: 
            case 160: 
            case 161: {
                break;
            }
            case 27: {
                if (!this.checkMethods || !this.isClassMethod(ast.getText())) break;
                this.log(ast, MSG_METHOD, ast.getText());
                break;
            }
            default: {
                if (!this.checkFields) break;
                this.processField(ast, parentType);
            }
        }
    }

    private void processField(DetailAST ast, int parentType) {
        String name;
        boolean typeName;
        boolean importOrPackage = ScopeUtils.getSurroundingScope(ast) == null;
        boolean methodNameInMethodCall = parentType == 59 && ast.getPreviousSibling() != null;
        boolean bl = typeName = parentType == 13 || parentType == 136;
        if (!(importOrPackage || methodNameInMethodCall || typeName || RequireThisCheck.isDeclarationToken(parentType) || !this.isClassField(name = ast.getText()))) {
            this.log(ast, MSG_VARIABLE, name);
        }
    }

    private static boolean isDeclarationToken(int parentType) {
        return DECLARATION_TOKENS.contains((Object)parentType);
    }
}

