/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.lang3.ArrayUtils;

public class UnnecessaryParenthesesCheck
extends AbstractCheck {
    public static final String MSG_IDENT = "unnecessary.paren.ident";
    public static final String MSG_ASSIGN = "unnecessary.paren.assign";
    public static final String MSG_EXPR = "unnecessary.paren.expr";
    public static final String MSG_LITERAL = "unnecessary.paren.literal";
    public static final String MSG_STRING = "unnecessary.paren.string";
    public static final String MSG_RETURN = "unnecessary.paren.return";
    private static final int MAX_QUOTED_LENGTH = 25;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private DetailAST parentToSkip;
    private int assignDepth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type != 80 || parent.getType() != 160) {
            boolean surrounded = UnnecessaryParenthesesCheck.isSurrounded(ast);
            if (surrounded && type == 58) {
                this.parentToSkip = ast.getParent();
                this.log(ast, MSG_IDENT, ast.getText());
            } else if (surrounded && UnnecessaryParenthesesCheck.isInTokenList(type, LITERALS)) {
                this.parentToSkip = ast.getParent();
                if (type == 139) {
                    this.log(ast, MSG_STRING, UnnecessaryParenthesesCheck.chopString(ast.getText()));
                } else {
                    this.log(ast, MSG_LITERAL, ast.getText());
                }
            } else if (UnnecessaryParenthesesCheck.isInTokenList(type, ASSIGNMENTS)) {
                ++this.assignDepth;
                DetailAST last = ast.getLastChild();
                if (last.getType() == 77) {
                    this.log(ast, MSG_ASSIGN, new Object[0]);
                }
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (type == 28) {
            if (this.parentToSkip != ast && UnnecessaryParenthesesCheck.isExprSurrounded(ast)) {
                if (this.assignDepth >= 1) {
                    this.log(ast, MSG_ASSIGN, new Object[0]);
                } else if (ast.getParent().getType() == 88) {
                    this.log(ast, MSG_RETURN, new Object[0]);
                } else {
                    this.log(ast, MSG_EXPR, new Object[0]);
                }
            }
            this.parentToSkip = null;
        } else if (UnnecessaryParenthesesCheck.isInTokenList(type, ASSIGNMENTS)) {
            --this.assignDepth;
        }
        super.leaveToken(ast);
    }

    private static boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        return prev != null && prev.getType() == 76;
    }

    private static boolean isExprSurrounded(DetailAST ast) {
        return ast.getFirstChild().getType() == 76;
    }

    private static boolean isInTokenList(int type, int ... tokens) {
        boolean found = false;
        for (int i = 0; i < tokens.length && !found; ++i) {
            found = tokens[i] == type;
        }
        return found;
    }

    private static String chopString(String value) {
        if (value.length() > 25) {
            return value.substring(0, 25) + "...\"";
        }
        return value;
    }
}

