/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.JavadocTokenTypes;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public final class JavadocUtils {
    private static final ImmutableMap<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;
    private static final String UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE = "Unknown javadoc token id. Given id: ";
    private static final Pattern COMMENT_PATTERN;
    private static final Pattern BLOCK_TAG_PATTERN_FIRST_LINE;
    private static final Pattern BLOCK_TAG_PATTERN;
    private static final Pattern INLINE_TAG_PATTERN;

    private JavadocUtils() {
    }

    public static JavadocTags getJavadocTags(TextBlock textBlock, JavadocTagType tagType) {
        String[] text = textBlock.getText();
        ArrayList tags = Lists.newArrayList();
        ArrayList invalidTags = Lists.newArrayList();
        for (int i = 0; i < text.length; ++i) {
            String textValue = text[i];
            Matcher blockTagMatcher = JavadocUtils.getBlockTagPattern(i).matcher(textValue);
            if ((tagType == JavadocTagType.ALL || tagType == JavadocTagType.BLOCK) && blockTagMatcher.find()) {
                String tagName = blockTagMatcher.group(1);
                String content = textValue.substring(blockTagMatcher.end(1));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                int line = textBlock.getStartLineNo() + i;
                int col = blockTagMatcher.start(1) - 1;
                if (i == 0) {
                    col += textBlock.getStartColNo();
                }
                if (JavadocTagInfo.isValidName(tagName)) {
                    tags.add(new JavadocTag(line, col, tagName, content.trim()));
                    continue;
                }
                invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                continue;
            }
            if (tagType != JavadocTagType.ALL && tagType != JavadocTagType.INLINE) continue;
            JavadocUtils.lookForInlineTags(textBlock, i, tags, invalidTags);
        }
        return new JavadocTags(tags, invalidTags);
    }

    private static Pattern getBlockTagPattern(int lineNumber) {
        Pattern blockTagPattern = lineNumber == 0 ? BLOCK_TAG_PATTERN_FIRST_LINE : BLOCK_TAG_PATTERN;
        return blockTagPattern;
    }

    private static void lookForInlineTags(TextBlock comment, int lineNumber, List<JavadocTag> validTags, List<InvalidJavadocTag> invalidTags) {
        int commentOffset;
        String commentContents;
        String text = comment.getText()[lineNumber];
        Matcher commentMatcher = COMMENT_PATTERN.matcher(text);
        if (commentMatcher.find()) {
            commentContents = commentMatcher.group(1);
            commentOffset = commentMatcher.start(1) - 1;
        } else {
            commentContents = text;
            commentOffset = 0;
        }
        Matcher tagMatcher = INLINE_TAG_PATTERN.matcher(commentContents);
        while (tagMatcher.find()) {
            String tagName = tagMatcher.group(1);
            String tagValue = tagMatcher.group(2).trim();
            int line = comment.getStartLineNo() + lineNumber;
            int col = commentOffset + tagMatcher.start(1) - 1;
            if (lineNumber == 0) {
                col += comment.getStartColNo();
            }
            if (JavadocTagInfo.isValidName(tagName)) {
                validTags.add(new JavadocTag(line, col, tagName, tagValue));
                continue;
            }
            invalidTags.add(new InvalidJavadocTag(line, col, tagName));
        }
    }

    public static boolean isJavadocComment(String commentContent) {
        boolean result = false;
        if (!commentContent.isEmpty()) {
            char docCommentIdentificator = commentContent.charAt(0);
            result = docCommentIdentificator == '*';
        }
        return result;
    }

    public static boolean isJavadocComment(DetailAST blockCommentBegin) {
        String commentContent = JavadocUtils.getBlockCommentContent(blockCommentBegin);
        return JavadocUtils.isJavadocComment(commentContent);
    }

    private static String getBlockCommentContent(DetailAST blockCommentBegin) {
        DetailAST commentContent = blockCommentBegin.getFirstChild();
        return commentContent.getText();
    }

    public static String getJavadocCommentContent(DetailAST javadocCommentBegin) {
        DetailAST commentContent = javadocCommentBegin.getFirstChild();
        return commentContent.getText().substring(1);
    }

    public static DetailNode findFirstToken(DetailNode detailNode, int type) {
        DetailNode returnValue = null;
        DetailNode node = JavadocUtils.getFirstChild(detailNode);
        while (node != null) {
            if (node.getType() == type) {
                returnValue = node;
                break;
            }
            node = JavadocUtils.getNextSibling(node);
        }
        return returnValue;
    }

    public static DetailNode getFirstChild(DetailNode node) {
        DetailNode resultNode = null;
        if (node.getChildren().length > 0) {
            resultNode = node.getChildren()[0];
        }
        return resultNode;
    }

    public static boolean containsInBranch(DetailNode node, int type) {
        DetailNode curNode = node;
        while (true) {
            if (type == curNode.getType()) {
                return true;
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                toVisit = JavadocUtils.getNextSibling(curNode);
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            if (curNode == toVisit) break;
            curNode = toVisit;
        }
        return false;
    }

    public static DetailNode getNextSibling(DetailNode node) {
        DetailNode[] children;
        int nextSiblingIndex;
        DetailNode parent = node.getParent();
        if (parent != null && (nextSiblingIndex = node.getIndex() + 1) <= (children = parent.getChildren()).length - 1) {
            return children[nextSiblingIndex];
        }
        return null;
    }

    public static DetailNode getNextSibling(DetailNode node, int tokenType) {
        DetailNode nextSibling = JavadocUtils.getNextSibling(node);
        while (nextSibling != null && nextSibling.getType() != tokenType) {
            nextSibling = JavadocUtils.getNextSibling(nextSibling);
        }
        return nextSibling;
    }

    public static DetailNode getPreviousSibling(DetailNode node) {
        DetailNode parent = node.getParent();
        int previousSiblingIndex = node.getIndex() - 1;
        DetailNode[] children = parent.getChildren();
        if (previousSiblingIndex >= 0) {
            return children[previousSiblingIndex];
        }
        return null;
    }

    public static String getTokenName(int id) {
        if (id == -1) {
            return "EOF";
        }
        if (id > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException(UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE + id);
        }
        String name = TOKEN_VALUE_TO_NAME[id];
        if (name == null) {
            throw new IllegalArgumentException(UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE + id);
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = (Integer)TOKEN_NAME_TO_VALUE.get((Object)name);
        if (id == null) {
            throw new IllegalArgumentException("Unknown javadoc token name. Given name " + name);
        }
        return id;
    }

    public static String getTagName(DetailNode javadocTagSection) {
        String javadocTagName = javadocTagSection.getType() == 10072 ? JavadocUtils.getNextSibling(JavadocUtils.getFirstChild(javadocTagSection)).getText() : JavadocUtils.getFirstChild(javadocTagSection).getText();
        return javadocTagName;
    }

    static {
        COMMENT_PATTERN = Pattern.compile("^\\s*(?:/\\*{2,}|\\*+)\\s*(.*)");
        BLOCK_TAG_PATTERN_FIRST_LINE = Pattern.compile("/\\*{2,}\\s*@(\\p{Alpha}+)\\s");
        BLOCK_TAG_PATTERN = Pattern.compile("^\\s*\\**\\s*@(\\p{Alpha}+)\\s");
        INLINE_TAG_PATTERN = Pattern.compile(".*?\\{@(\\p{Alpha}+)\\s+(.*?)\\}");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Field[] fields = JavadocTokenTypes.class.getDeclaredFields();
        String[] tempTokenValueToName = ArrayUtils.EMPTY_STRING_ARRAY;
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
            String name = field.getName();
            int tokenValue = TokenUtils.getIntFromField(field, name);
            builder.put((Object)name, (Object)tokenValue);
            if (tokenValue > tempTokenValueToName.length - 1) {
                String[] temp = new String[tokenValue + 1];
                System.arraycopy(tempTokenValueToName, 0, temp, 0, tempTokenValueToName.length);
                tempTokenValueToName = temp;
            }
            if (tokenValue == -1) {
                tempTokenValueToName[0] = name;
                continue;
            }
            tempTokenValueToName[tokenValue] = name;
        }
        TOKEN_NAME_TO_VALUE = builder.build();
        TOKEN_VALUE_TO_NAME = tempTokenValueToName;
    }

    public static enum JavadocTagType {
        BLOCK,
        INLINE,
        ALL;

    }
}

