/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class ElementNode
extends AbstractNode {
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final AbstractNode root;
    private final AbstractNode parent;
    private final DetailAST detailAst;
    private final String text;
    private AbstractNode[] attributes;
    private String ident;

    public ElementNode(AbstractNode root, AbstractNode parent, DetailAST detailAst) {
        super(root.getTreeInfo());
        this.parent = parent;
        this.root = root;
        this.detailAst = detailAst;
        this.setIdent();
        this.createChildren();
        this.text = TokenUtil.getTokenName(detailAst.getType());
    }

    private void createChildren() {
        for (DetailAST currentChild = this.detailAst.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            ElementNode child = new ElementNode(this.root, this, currentChild);
            this.addChild(child);
        }
    }

    public String getAttributeValue(String namespace, String localPart) {
        if (TEXT_ATTRIBUTE_NAME.equals(localPart)) {
            return this.ident;
        }
        throw ElementNode.throwUnsupportedOperationException();
    }

    public String getLocalPart() {
        return this.text;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public NodeInfo getRoot() {
        return this.root;
    }

    public String getStringValue() {
        return this.text;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: {
                result = new Navigator.AncestorEnumeration((NodeInfo)this, false);
                break;
            }
            case 1: {
                result = new Navigator.AncestorEnumeration((NodeInfo)this, true);
                break;
            }
            case 2: {
                if (this.attributes == null) {
                    result = EmptyIterator.OfNodes.THE_INSTANCE;
                    break;
                }
                result = new ArrayIterator.OfNodes((NodeInfo[])this.attributes);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 5: {
                result = new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
                break;
            }
            case 9: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this.parent);
                break;
            }
            case 12: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this);
                break;
            }
            default: {
                throw ElementNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return this.detailAst.getType();
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private void setIdent() {
        DetailAST identAst = this.detailAst.findFirstToken(58);
        if (identAst != null) {
            this.ident = identAst.getText();
            this.attributes = new AbstractNode[1];
            this.attributes[0] = new AttributeNode(TEXT_ATTRIBUTE_NAME, this.ident);
        }
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

