/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class DeclarationOrderCheck
extends AbstractCheck {
    public static final String MSG_CONSTRUCTOR = "declaration.order.constructor";
    public static final String MSG_STATIC = "declaration.order.static";
    public static final String MSG_INSTANCE = "declaration.order.instance";
    public static final String MSG_ACCESS = "declaration.order.access";
    private static final int STATE_STATIC_VARIABLE_DEF = 1;
    private static final int STATE_INSTANCE_VARIABLE_DEF = 2;
    private static final int STATE_CTOR_DEF = 3;
    private static final int STATE_METHOD_DEF = 4;
    private Deque<ScopeState> scopeStates;
    private Set<String> classFieldNames;
    private boolean ignoreConstructors;
    private boolean ignoreModifiers;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{8, 9, 5, 6, 10};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.scopeStates = new ArrayDeque<ScopeState>();
        this.classFieldNames = new HashSet<String>();
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (ast.getType()) {
            case 6: {
                this.scopeStates.push(new ScopeState());
                break;
            }
            case 5: {
                if (parentType != 10 || ast.getParent().getParent().getType() != 6) break;
                this.processModifiers(ast);
                break;
            }
            case 8: {
                if (parentType != 6) break;
                this.processConstructor(ast);
                break;
            }
            case 9: {
                if (parentType != 6) break;
                ScopeState state = this.scopeStates.peek();
                state.currentScopeState = 4;
                break;
            }
            case 10: {
                if (!ScopeUtil.isClassFieldDef(ast)) break;
                DetailAST fieldDef = ast.findFirstToken(58);
                this.classFieldNames.add(fieldDef.getText());
                break;
            }
        }
    }

    private void processConstructor(DetailAST ast) {
        ScopeState state = this.scopeStates.peek();
        if (state.currentScopeState > 3) {
            if (!this.ignoreConstructors) {
                this.log(ast, MSG_CONSTRUCTOR, new Object[0]);
            }
        } else {
            state.currentScopeState = 3;
        }
    }

    private void processModifiers(DetailAST ast) {
        ScopeState state = this.scopeStates.peek();
        boolean isStateValid = this.processModifiersState(ast, state);
        this.processModifiersSubState(ast, state, isStateValid);
    }

    private boolean processModifiersState(DetailAST modifierAst, ScopeState state) {
        boolean isStateValid = true;
        if (modifierAst.findFirstToken(64) == null) {
            if (state.currentScopeState > 2) {
                isStateValid = false;
                this.log(modifierAst, MSG_INSTANCE, new Object[0]);
            } else if (state.currentScopeState == 1) {
                state.declarationAccess = Scope.PUBLIC;
                state.currentScopeState = 2;
            }
        } else if (state.currentScopeState > 1) {
            if (!this.ignoreModifiers || state.currentScopeState > 2) {
                isStateValid = false;
                this.log(modifierAst, MSG_STATIC, new Object[0]);
            }
        } else {
            state.currentScopeState = 1;
        }
        return isStateValid;
    }

    private void processModifiersSubState(DetailAST modifiersAst, ScopeState state, boolean isStateValid) {
        Scope access = ScopeUtil.getScopeFromMods(modifiersAst);
        if (state.declarationAccess.compareTo(access) > 0) {
            if (isStateValid && !this.ignoreModifiers && !this.isForwardReference(modifiersAst.getParent())) {
                this.log(modifiersAst, MSG_ACCESS, new Object[0]);
            }
        } else {
            state.declarationAccess = access;
        }
    }

    private boolean isForwardReference(DetailAST fieldDef) {
        DetailAST exprStartIdent = fieldDef.findFirstToken(58);
        Set<DetailAST> exprIdents = DeclarationOrderCheck.getAllTokensOfType(exprStartIdent, 58);
        boolean forwardReference = false;
        for (DetailAST ident : exprIdents) {
            if (!this.classFieldNames.contains(ident.getText())) continue;
            forwardReference = true;
            break;
        }
        return forwardReference;
    }

    private static Set<DetailAST> getAllTokensOfType(DetailAST ast, int tokenType) {
        DetailAST vertex = ast;
        HashSet<DetailAST> result = new HashSet<DetailAST>();
        ArrayDeque<DetailAST> stack = new ArrayDeque<DetailAST>();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)((Object)stack.pop());
            }
            while (vertex != null) {
                if (vertex.getType() == tokenType && !vertex.equals((AST)ast)) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 6) {
            this.scopeStates.pop();
        }
    }

    public void setIgnoreConstructors(boolean ignoreConstructors) {
        this.ignoreConstructors = ignoreConstructors;
    }

    public void setIgnoreModifiers(boolean ignoreModifiers) {
        this.ignoreModifiers = ignoreModifiers;
    }

    private static class ScopeState {
        private int currentScopeState = 1;
        private Scope declarationAccess = Scope.PUBLIC;

        private ScopeState() {
        }
    }
}

