/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

@StatelessCheck
public final class IllegalThrowsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.throw";
    private final Set<String> ignoredMethodNames = Arrays.stream(new String[]{"finalize"}).collect(Collectors.toSet());
    private final Set<String> illegalClassNames = Arrays.stream(new String[]{"Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.RuntimeException", "java.lang.Throwable"}).collect(Collectors.toSet());
    private boolean ignoreOverriddenMethods = true;

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        this.illegalClassNames.addAll(CheckUtil.parseClassNames(classNames));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST methodDef = detailAST.getParent();
        if (!this.isIgnorableMethod(methodDef)) {
            for (DetailAST token = detailAST.getFirstChild(); token != null; token = token.getNextSibling()) {
                FullIdent ident;
                if (token.getType() == 74 || !this.illegalClassNames.contains((ident = FullIdent.createFullIdent(token)).getText())) continue;
                this.log(token, MSG_KEY, ident.getText());
            }
        }
    }

    private boolean isIgnorableMethod(DetailAST methodDef) {
        return this.shouldIgnoreMethod(methodDef.findFirstToken(58).getText()) || this.ignoreOverriddenMethods && (AnnotationUtil.containsAnnotation(methodDef, "Override") || AnnotationUtil.containsAnnotation(methodDef, "java.lang.Override"));
    }

    private boolean shouldIgnoreMethod(String name) {
        return this.ignoredMethodNames.contains(name);
    }

    public void setIgnoredMethodNames(String ... methodNames) {
        this.ignoredMethodNames.clear();
        Collections.addAll(this.ignoredMethodNames, methodNames);
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }
}

