/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@StatelessCheck
public class AtclauseOrderCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "at.clause.order";
    private static final String[] DEFAULT_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated"};
    private List<Integer> target = Arrays.asList(14, 15, 154, 9, 8, 10);
    private List<String> tagOrder = Arrays.asList(DEFAULT_ORDER);

    public void setTarget(String ... targets) {
        ArrayList<Integer> customTarget = new ArrayList<Integer>();
        for (String temp : targets) {
            customTarget.add(TokenUtil.getTokenId(temp.trim()));
        }
        this.target = customTarget;
    }

    public void setTagOrder(String ... orders) {
        ArrayList<String> customOrder = new ArrayList<String>();
        for (String order : orders) {
            customOrder.add(order.trim());
        }
        this.tagOrder = customOrder;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        int parentType = AtclauseOrderCheck.getParentType(this.getBlockCommentAst());
        if (this.target.contains(parentType)) {
            this.checkOrderInTagSection(ast);
        }
    }

    private void checkOrderInTagSection(DetailNode javadoc) {
        int maxIndexOfPreviousTag = 0;
        for (DetailNode node : javadoc.getChildren()) {
            String tagText;
            int indexOfCurrentTag;
            if (node.getType() != 10071 || (indexOfCurrentTag = this.tagOrder.indexOf(tagText = JavadocUtil.getFirstChild(node).getText())) == -1) continue;
            if (indexOfCurrentTag < maxIndexOfPreviousTag) {
                this.log(node.getLineNumber(), MSG_KEY, this.tagOrder.toString());
                continue;
            }
            maxIndexOfPreviousTag = indexOfCurrentTag;
        }
    }

    private static int getParentType(DetailAST commentBlock) {
        DetailAST parentNode = commentBlock.getParent();
        int result = 0;
        if (parentNode != null && ((result = parentNode.getType()) == 13 || result == 5)) {
            result = parentNode.getParent().getType();
        }
        return result;
    }
}

