/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.Violation;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class DefaultLogger
extends AutomaticBean
implements AuditListener {
    public static final String ADD_EXCEPTION_MESSAGE = "DefaultLogger.addException";
    public static final String AUDIT_STARTED_MESSAGE = "DefaultLogger.auditStarted";
    public static final String AUDIT_FINISHED_MESSAGE = "DefaultLogger.auditFinished";
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, outputStreamOptions, outputStream, AutomaticBean.OutputStreamOptions.NONE);
    }

    public DefaultLogger(OutputStream infoStream, AutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AutomaticBean.OutputStreamOptions errorStreamOptions) {
        this(infoStream, infoStreamOptions, errorStream, errorStreamOptions, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, AutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AutomaticBean.OutputStreamOptions errorStreamOptions, AuditEventFormatter messageFormatter) {
        if (infoStreamOptions == null) {
            throw new IllegalArgumentException("Parameter infoStreamOptions can not be null");
        }
        boolean bl = this.closeInfo = infoStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        if (errorStreamOptions == null) {
            throw new IllegalArgumentException("Parameter errorStreamOptions can not be null");
        }
        this.closeError = errorStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        if (infoStream == errorStream) {
            this.errorWriter = this.infoWriter;
        } else {
            OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
            this.errorWriter = new PrintWriter(errorStreamWriter);
        }
        this.formatter = messageFormatter;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            Violation addExceptionMessage = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", ADD_EXCEPTION_MESSAGE, new String[]{event.getFileName()}, null, Violation.class, null);
            this.errorWriter.println(addExceptionMessage.getViolation());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        Violation auditStartMessage = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", AUDIT_STARTED_MESSAGE, null, null, Violation.class, null);
        this.infoWriter.println(auditStartMessage.getViolation());
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        Violation auditFinishMessage = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", AUDIT_FINISHED_MESSAGE, null, null, Violation.class, null);
        this.infoWriter.println(auditFinishMessage.getViolation());
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }
}

