/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MetadataGeneratorUtil {
    private MetadataGeneratorUtil() {
    }

    public static void generate(String ... args) throws IOException, CheckstyleException {
        JavadocMetadataScraper.resetModuleDetailsStore();
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(JavadocMetadataScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty("charset", StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        checker.configure(defaultConfiguration);
        MetadataGeneratorUtil.dumpMetadata(checker, args[0]);
    }

    private static void dumpMetadata(Checker checker, String path) throws CheckstyleException, IOException {
        ArrayList<File> validFiles = new ArrayList<File>();
        List<String> moduleFolders = Arrays.asList("checks", "filters", "filefilters");
        for (String folder : moduleFolders) {
            Stream<Path> files = Files.walk(Paths.get(path + "/" + folder, new String[0]), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                validFiles.addAll(files.map(Path::toFile).filter(file -> file.getName().endsWith("SuppressWarningsHolder.java") || file.getName().endsWith("Check.java") || file.getName().endsWith("Filter.java")).collect(Collectors.toList()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (files == null) continue;
                if (throwable != null) {
                    try {
                        files.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                files.close();
            }
        }
        checker.process(validFiles);
    }
}

