/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.sbt.versioning;

import com.rallyhealth.sbt.versioning.BufferingProcessLogger;
import com.rallyhealth.sbt.versioning.GitBranchState;
import com.rallyhealth.sbt.versioning.GitBranchStateNoCommits$;
import com.rallyhealth.sbt.versioning.GitBranchStateNoReleases;
import com.rallyhealth.sbt.versioning.GitBranchStateOneReleaseHead;
import com.rallyhealth.sbt.versioning.GitBranchStateOneReleaseNotHead;
import com.rallyhealth.sbt.versioning.GitBranchStateTwoReleases;
import com.rallyhealth.sbt.versioning.GitCommit;
import com.rallyhealth.sbt.versioning.GitCommit$;
import com.rallyhealth.sbt.versioning.GitCommitWithCount;
import com.rallyhealth.sbt.versioning.GitDriver;
import com.rallyhealth.sbt.versioning.GitWorkingState;
import com.rallyhealth.sbt.versioning.ReleaseVersion;
import com.rallyhealth.sbt.versioning.ReleaseVersion$;
import com.rallyhealth.sbt.versioning.SemanticVersion;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001-\u0011QbR5u\tJLg/\u001a:J[Bd'BA\u0002\u0005\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u000b\u0019\t1a\u001d2u\u0015\t9\u0001\"A\u0006sC2d\u0017\u0010[3bYRD'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0011bR5u\tJLg/\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\t1\u0001Z5s!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0002j_*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u00111\u0015\u000e\\3\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019C\u0005\u0005\u0002\u0014\u0001!)q\u0003\ta\u00011\u0019!a\u0005\u0001\u0003(\u000519\u0015\u000e^#yG\u0016\u0004H/[8o'\t)\u0003\u0006\u0005\u0002*c9\u0011!f\f\b\u0003W9j\u0011\u0001\f\u0006\u0003[)\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005Ar\u0011a\u00029bG.\fw-Z\u0005\u0003eM\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0005Ar\u0001\u0002C\u001b&\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u00075\u001cx\r\u0005\u00028w9\u0011\u0001(\u000f\t\u0003W9I!A\u000f\b\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u9AQ!I\u0013\u0005\u0002}\"\"\u0001\u0011\"\u0011\u0005\u0005+S\"\u0001\u0001\t\u000bUr\u0004\u0019\u0001\u001c\t\u000b\u0011\u0003A\u0011C#\u0002\u001f%\u001cx)\u001b;D_6\u0004\u0018\r^5cY\u0016,\u0012A\u0012\t\u0003\u001b\u001dK!\u0001\u0013\b\u0003\u000f\t{w\u000e\\3b]\")!\n\u0001C\u0005\u0017\u0006I\u0011n]$jiJ+\u0007o\u001c\u000b\u0003\r2CQaF%A\u0002aAqA\u0014\u0001C\u0002\u0013\u0005s*A\u0006ce\u0006t7\r[*uCR,W#\u0001)\u0011\u0005M\t\u0016B\u0001*\u0003\u000599\u0015\u000e\u001e\"sC:\u001c\u0007n\u0015;bi\u0016Da\u0001\u0016\u0001!\u0002\u0013\u0001\u0016\u0001\u00042sC:\u001c\u0007n\u0015;bi\u0016\u0004\u0003\"\u0002,\u0001\t\u0003:\u0016\u0001D<pe.LgnZ*uCR,W#\u0001-\u0011\u0005MI\u0016B\u0001.\u0003\u0005=9\u0015\u000e^,pe.LgnZ*uCR,\u0007\"\u0002/\u0001\t\u0003j\u0016AD4fi\u000e{W.\\5u\u0007>,h\u000e\u001e\u000b\u0003=\u0006\u0004\"!D0\n\u0005\u0001t!aA%oi\")!m\u0017a\u0001G\u0006!\u0001.Y:i!\riAMN\u0005\u0003K:\u0011aa\u00149uS>t\u0007\"B4\u0001\t\u0013A\u0017!C4ji\n\u0013\u0018M\\2i+\u00051\u0004\"\u00026\u0001\t\u0013Y\u0017!D4ji\u001a{'/R1dQJ+g\r\u0006\u0002meB\u0019\u0011&\\8\n\u00059\u001c$aA*fcB\u00111\u0003]\u0005\u0003c\n\u0011\u0011bR5u\u0007>lW.\u001b;\t\u000bML\u0007\u0019\u0001\u001c\u0002\u0013\u0005\u0014x-^7f]R\u001c\b\"B;\u0001\t\u00131\u0018AB4ji2{w\r\u0006\u0002mo\")1\u000f\u001ea\u0001m!)\u0011\u0010\u0001C\u0005u\u0006Q1\r[3dW\u000ecW-\u00198\u0015\u0003\u0019CQ\u0001 \u0001\u0005\nu\f\u0011DZ5oI\u0006\u0013'M]3wS\u0006$X\r\u001a%bg\"dUM\\4uQR\ta\f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001\u000beVt7i\\7nC:$GCBA\u0002\u0003\u0017\ty\u0001\u0005\u0004\u000e\u0003\u000bq\u0016\u0011B\u0005\u0004\u0003\u000fq!A\u0002+va2,'\u0007E\u0002*[ZBa!!\u0004\u007f\u0001\u00041\u0014aA2nI\"A\u0011\u0011\u0003@\u0011\u0002\u0003\u0007a)\u0001\buQJ|w/\u00134O_:TVM]8\t\u0013\u0005U\u0001!%A\u0005\n\u0005]\u0011\u0001\u0006:v]\u000e{W.\\1oI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u001a)\u001aa)a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class GitDriverImpl
implements GitDriver {
    private final File dir;
    private final GitBranchState branchState;

    @Override
    public SemanticVersion calcCurrentVersion(boolean ignoreDirty) {
        return GitDriver.calcCurrentVersion$(this, ignoreDirty);
    }

    public boolean isGitCompatible() {
        boolean bl;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git --version", this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Regex gitSemver = new StringOps(Predef$.MODULE$.augmentString("git version (\\d+)\\.(\\d+)\\.(\\d+).*")).r();
        int n = exitCode;
        switch (n) {
            case 0: {
                String gitVersion;
                String string = gitVersion = outputLogger.stdout().mkString("").trim().toLowerCase();
                Option option = gitSemver.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                    String major = (String)((LinearSeqOptimized)option.get()).apply(0);
                    bl = new StringOps(Predef$.MODULE$.augmentString(major)).toInt() > 1;
                    break;
                }
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Version output was not of the form 'git version x.y.z'\n              |version was '").append(gitVersion).append("'").toString())).stripMargin());
            }
            default: {
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
            }
        }
        return bl;
    }

    private boolean isGitRepo(File dir) {
        boolean bl;
        int exitCode;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = exitCode = Process$.MODULE$.apply("git rev-parse --is-inside-work-tree", dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                String string = outputLogger.stdout().mkString("").trim().toLowerCase();
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 128: {
                bl = false;
                break;
            }
            default: {
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
            }
        }
        return bl;
    }

    @Override
    public GitBranchState branchState() {
        return this.branchState;
    }

    @Override
    public GitWorkingState workingState() {
        return new GitWorkingState(!this.checkClean());
    }

    @Override
    public int getCommitCount(Option<String> hash) {
        Seq output;
        String limitStr = (String)hash.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("^").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(new StringBuilder(41).append("git rev-list --first-parent --count HEAD ").append(limitStr).toString().trim(), this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return new StringOps(Predef$.MODULE$.augmentString(output2.mkString("").trim())).toInt();
    }

    private String gitBranch() {
        Seq res;
        String cmd = "git rev-parse --abbrev-ref HEAD";
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: {
                res = (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> line, Seq$.MODULE$.canBuildFrom());
                break;
            }
            case 128: {
                throw new IllegalStateException("Error 128: a git cmd was run in a dir that is not under git vcs or git rev-parse failed to run.");
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return (String)res.head();
    }

    private Seq<GitCommit> gitForEachRef(String arguments) {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(54).append("git for-each-ref --sort=-v:refname refs/tags --merged=").append(this.gitBranch()).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitRef((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<GitCommit> gitLog(String arguments) {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(79).append("git log --oneline --decorate=short --simplify-by-decoration --no-abbrev-commit ").append(arguments).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitLog((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
    }

    private boolean checkClean() {
        Seq output;
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git status --porcelain --untracked-files=no", this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return output2.mkString("").isEmpty();
    }

    private int findAbbreviatedHashLength() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git rev-parse --short HEAD", false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(47).append("Non-zero exit code when running git rev-parse: ").append(n).toString());
            }
        }
        return package$.MODULE$.max(output2.mkString("").trim().length(), 7);
    }

    private Tuple2<Object, Seq<String>> runCommand(String cmd, boolean throwIfNonZero) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply(cmd, this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Tuple2 result = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), outputLogger.stdout());
        if (throwIfNonZero && exitCode != 0) {
            throw new IllegalStateException(new StringBuilder(36).append("Non-zero exit code when running '").append(cmd).append("': ").append(exitCode).toString());
        }
        return result;
    }

    private boolean runCommand$default$2() {
        return true;
    }

    public static final /* synthetic */ String $anonfun$new$1() {
        return "Must be in a git repository";
    }

    public static final /* synthetic */ String $anonfun$new$2() {
        return "Must be git version 2.X.X or greater";
    }

    public static final /* synthetic */ Tuple2 $anonfun$branchState$1(GitDriverImpl $this, Tuple2 tp) {
        return new Tuple2($this.gitLog(new StringBuilder(14).append(((GitCommit)tp._1()).fullHash()).append(" --max-count=1").toString()).head(), tp._2());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public GitDriverImpl(File dir) {
        block15: {
            block12: {
                block14: {
                    block13: {
                        this.dir = dir;
                        super();
                        GitDriver.$init$(this);
                        Predef$.MODULE$.require(this.isGitRepo(dir), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$1(), ()Ljava/lang/String;)());
                        Predef$.MODULE$.require(this.isGitCompatible(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$2(), ()Ljava/lang/String;)());
                        var4_2 = this.gitLog("--max-count=1").headOption();
                        if (!(var4_2 instanceof Some)) break block12;
                        var5_3 = (Some)var4_2;
                        headCommit = (GitCommit)var5_3.value();
                        releaseRefs = (Seq)this.gitForEachRef("").collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends GitCommit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(A1);
                                if (!option.isEmpty()) {
                                    ReleaseVersion rv = (ReleaseVersion)option.get();
                                    object = new Tuple2(A1, (Object)rv);
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(GitCommit x1) {
                                GitCommit gitCommit = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(gitCommit);
                                boolean bl = !option.isEmpty();
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        releases = (Seq)((TraversableLike)releaseRefs.take(2)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$branchState$1(com.rallyhealth.sbt.versioning.GitDriverImpl scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((GitDriverImpl)this), Seq$.MODULE$.canBuildFrom());
                        maybeCurrRelease = releases.headOption();
                        var11_9 = new Tuple2((Object)maybeCurrRelease, (Object)(maybePrevRelease = ((TraversableLike)releases.drop(1)).headOption()));
                        if (var11_9 != null) {
                            var12_10 = (Option)var11_9._1();
                            var13_11 = (Option)var11_9._2();
                            if (var12_10 instanceof Some && (var15_13 = (Tuple2)(var14_12 = (Some)var12_10).value()) != null) {
                                currCommit = (GitCommit)var15_13._1();
                                if (var13_11 instanceof Some && (var18_16 = (Tuple2)(var17_15 = (Some)var13_11).value()) != null) {
                                    prevCommit = (GitCommit)var18_16._1();
                                    v0 = currCommit;
                                    var20_18 = prevCommit;
                                    if (!(v0 != null ? v0.equals(var20_18) == false : var20_18 != null)) {
                                        throw new IllegalStateException(new StringBuilder(36).append("currCommit=").append(currCommit).append(" cannot equal prevCommit=").append(prevCommit).toString());
                                    }
                                }
                            }
                        }
                        if (var11_9 == null) break block13;
                        var21_19 = (Option)var11_9._1();
                        var22_20 = (Option)var11_9._2();
                        if (!(var21_19 instanceof Some) || (var24_22 = (Tuple2)(var23_21 = (Some)var21_19).value()) == null) break block13;
                        currCommit = (GitCommit)var24_22._1();
                        currVersion = (ReleaseVersion)var24_22._2();
                        if (!(var22_20 instanceof Some) || (var28_26 = (Tuple2)(var27_25 = (Some)var22_20).value()) == null) break block13;
                        prevCommit = (GitCommit)var28_26._1();
                        prevVersion = (ReleaseVersion)var28_26._2();
                        v1 = currCommit;
                        var31_29 = headCommit;
                        if (v1 != null ? v1.equals(var31_29) == false : var31_29 != null) break block13;
                        var3_30 /* !! */  = new GitBranchStateTwoReleases(currCommit, currVersion, prevCommit, prevVersion);
                        break block14;
                    }
                    if (var11_9 == null) ** GOTO lbl-1000
                    var32_31 = (Option)var11_9._1();
                    var33_32 = (Option)var11_9._2();
                    if (!(var32_31 instanceof Some) || (var35_34 = (Tuple2)(var34_33 = (Some)var32_31).value()) == null) ** GOTO lbl-1000
                    currCommit = (GitCommit)var35_34._1();
                    currVersion = (ReleaseVersion)var35_34._2();
                    if (!None$.MODULE$.equals(var33_32)) ** GOTO lbl-1000
                    v2 = currCommit;
                    var38_37 = headCommit;
                    if (!(v2 != null ? v2.equals(var38_37) == false : var38_37 != null)) {
                        var3_30 /* !! */  = new GitBranchStateOneReleaseHead(currCommit, currVersion);
                    } else if (var11_9 != null && (var39_38 = (Option)var11_9._1()) instanceof Some && (var41_40 = (Tuple2)(var40_39 = (Some)var39_38).value()) != null) {
                        currCommit = (GitCommit)var41_40._1();
                        currVersion = (ReleaseVersion)var41_40._2();
                        headCommitWithCount = new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)new Some((Object)currCommit.fullHash())));
                        var3_30 /* !! */  = new GitBranchStateOneReleaseNotHead(headCommitWithCount, currCommit, currVersion);
                    } else if (var11_9 != null && None$.MODULE$.equals(var45_44 = (Option)var11_9._1())) {
                        var3_30 /* !! */  = new GitBranchStateNoReleases(new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)None$.MODULE$)));
                    } else {
                        throw new MatchError((Object)var11_9);
                    }
                }
                var2_45 /* !! */  = var3_30 /* !! */ ;
                break block15;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_45 /* !! */  = GitBranchStateNoCommits$.MODULE$;
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        this.branchState = var2_45 /* !! */ ;
    }

    public class GitException
    extends Exception {
        public /* synthetic */ GitDriverImpl com$rallyhealth$sbt$versioning$GitDriverImpl$GitException$$$outer() {
            return GitDriverImpl.this;
        }

        public GitException(String msg) {
            if (GitDriverImpl.this == null) {
                throw null;
            }
            super(msg);
        }
    }
}

