/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.CommandArgs;

public class RedisModulesCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    private static final String MUST_NOT_BE_NULL = "must not be null";
    private static final String MUST_NOT_BE_EMPTY = "must not be empty";

    protected CommandArgs<K, V> args(K key) {
        RedisModulesCommandBuilder.notNullKey(key);
        return new CommandArgs(this.codec).addKey(key);
    }

    protected RedisModulesCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected static void notNull(Object arg, String name) {
        LettuceAssert.notNull((Object)arg, (String)(name + " " + MUST_NOT_BE_NULL));
    }

    protected static void notNull(KeyStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, (String)"KeyValueStreamingChannel must not be null");
    }

    protected static void notNull(ValueStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, (String)"ValueStreamingChannel must not be null");
    }

    protected static void notNull(KeyValueStreamingChannel<?, ?> channel) {
        LettuceAssert.notNull(channel, (String)"KeyValueStreamingChannel must not be null");
    }

    protected static void notEmptyKeys(Object[] keys) {
        RedisModulesCommandBuilder.notNull(keys, "Keys");
        LettuceAssert.notEmpty((Object[])keys, (String)"Keys must not be empty");
    }

    protected static void notEmptyValues(Object[] values) {
        RedisModulesCommandBuilder.notNull(values, "Values");
        LettuceAssert.notEmpty((Object[])values, (String)"Values must not be empty");
    }

    protected static void notEmpty(Object[] array, String name) {
        RedisModulesCommandBuilder.notNull(array, name);
        LettuceAssert.notEmpty((Object[])array, (String)(name + " " + MUST_NOT_BE_EMPTY));
    }

    protected static void notNullKey(Object key) {
        RedisModulesCommandBuilder.notNull(key, "Key");
    }
}

