/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.Reducer;
import com.redis.lettucemod.search.Reducers;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Group
implements AggregateOperation {
    private final String[] properties;
    private final Reducer[] reducers;

    public Group(String[] properties, Reducer[] reducers) {
        LettuceAssert.notNull((Object)properties, (String)"Properties must not be null");
        LettuceAssert.noNullElements((Object[])properties, (String)"Property elements must not be null");
        LettuceAssert.notEmpty((Object[])reducers, (String)"Group must have at least one reducer");
        LettuceAssert.noNullElements((Object[])reducers, (String)"Reducer elements must not be null");
        this.properties = properties;
        this.reducers = reducers;
    }

    @Override
    public void build(SearchCommandArgs args) {
        args.add(SearchCommandKeyword.GROUPBY);
        args.add(this.properties.length);
        for (String property : this.properties) {
            args.addProperty(property);
        }
        for (Reducer reducer : this.reducers) {
            reducer.build(args);
        }
    }

    public static GroupByBuilder by(String ... properties) {
        return new GroupByBuilder(properties);
    }

    public static class GroupByBuilder {
        private final List<String> properties = new ArrayList<String>();
        private final List<Reducer> reducers = new ArrayList<Reducer>();

        public GroupByBuilder(String ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public GroupByBuilder property(String property) {
            return new GroupByBuilder(property);
        }

        public GroupByBuilder avg(Reducers.Avg avg) {
            return this.reducer(avg);
        }

        public GroupByBuilder count(Reducers.Count count) {
            return this.reducer(count);
        }

        public GroupByBuilder countDistinct(Reducers.CountDistinct countDistinct) {
            return this.reducer(countDistinct);
        }

        public GroupByBuilder countDistinctish(Reducers.CountDistinctish countDistinctish) {
            return this.reducer(countDistinctish);
        }

        public GroupByBuilder firstValue(Reducers.FirstValue firstValue) {
            return this.reducer(firstValue);
        }

        public GroupByBuilder min(Reducers.Min min) {
            return this.reducer(min);
        }

        public GroupByBuilder max(Reducers.Max max) {
            return this.reducer(max);
        }

        public GroupByBuilder quantile(Reducers.Quantile quantile) {
            return this.reducer(quantile);
        }

        public GroupByBuilder randomSample(Reducers.RandomSample randomSample) {
            return this.reducer(randomSample);
        }

        public GroupByBuilder stdDev(Reducers.StdDev stdDev) {
            return this.reducer(stdDev);
        }

        public GroupByBuilder sum(Reducers.Sum sum) {
            return this.reducer(sum);
        }

        public GroupByBuilder toList(Reducers.ToList toList) {
            return this.reducer(toList);
        }

        public GroupByBuilder reducer(Reducer reducer) {
            return this.reducers(reducer);
        }

        public GroupByBuilder reducers(Reducer ... reducers) {
            Collections.addAll(this.reducers, reducers);
            return this;
        }

        public Group build() {
            return new Group(this.properties.toArray(new String[0]), this.reducers.toArray(new Reducer[0]));
        }
    }
}

