/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;

public class Aggregation
implements CompositeArgument {
    private final Type type;
    private final long timeBucket;

    public Aggregation(Type type, long timeBucket) {
        LettuceAssert.notNull((Object)((Object)type), (String)"Aggregation type is required");
        LettuceAssert.isTrue((timeBucket > 0L ? 1 : 0) != 0, (String)"A time bucket is required");
        this.type = type;
        this.timeBucket = timeBucket;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        args.add((ProtocolKeyword)TimeSeriesCommandKeyword.AGGREGATION);
        args.add(this.type.getName());
        args.add(this.timeBucket);
    }

    public static Aggregation of(Type type, long timeBucket) {
        return new Aggregation(type, timeBucket);
    }

    public static enum Type {
        AVG,
        SUM,
        MIN,
        MAX,
        RANGE,
        COUNT,
        FIRST,
        LAST,
        STD_P("STD.P"),
        STD_S("STD.S"),
        VAR_P("VAR.P"),
        VAR_S("VAR.S");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }

        private Type() {
            this.name = this.name();
        }
    }
}

