/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.junit.jupiter;

import com.redis.testcontainers.RedisServer;
import com.redis.testcontainers.junit.jupiter.RedisTestContext;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractTestcontainersRedisTestBase {
    private Map<RedisServer, RedisTestContext> contexts;

    protected abstract Collection<RedisServer> servers();

    protected RedisTestContext getContext(RedisServer server) {
        return this.contexts.get(server);
    }

    protected Collection<RedisServer> testServers() {
        return this.servers();
    }

    protected Collection<RedisTestContext> getAllContexts() {
        return this.contexts.values();
    }

    protected Collection<RedisTestContext> getTestContexts() {
        return this.testServers().stream().map(this.contexts::get).collect(Collectors.toList());
    }

    @BeforeAll
    protected void setupContexts() {
        this.contexts = this.servers().stream().collect(Collectors.toMap(s -> s, RedisTestContext::new));
    }

    @BeforeEach
    protected void flushAll() {
        this.contexts.forEach((k, v) -> {
            v.sync().flushall();
            Awaitility.await().until(() -> v.sync().dbsize() == 0L);
        });
    }

    @AfterAll
    protected void teardownContexts() {
        this.contexts.values().forEach(RedisTestContext::close);
        this.contexts.clear();
    }
}

