/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support;

import com.redis.testcontainers.RedisServer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang.ClassUtils;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractRedisContainer<C extends AbstractRedisContainer<C>>
extends GenericContainer<C>
implements RedisServer {
    public static final int REDIS_PORT = 6379;

    protected AbstractRedisContainer(DockerImageName dockerImageName) {
        this(dockerImageName, 6379);
    }

    protected AbstractRedisContainer(DockerImageName dockerImageName, int port) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{port});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready to accept connections.*\\n", (int)1));
    }

    @Override
    public String getRedisURI() {
        return RedisServer.redisURI(this);
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass()) + " " + this.getRedisURI();
    }
}

