/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support;

import java.time.Duration;
import java.util.concurrent.Callable;

public class RetryCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final Duration sleep;
    private final Duration timeout;

    public RetryCallable(Callable<T> delegate, Duration sleep, Duration timeout) {
        this.delegate = delegate;
        this.sleep = sleep;
        this.timeout = timeout;
    }

    public static <T> DelegateBuilder<T> delegate(Callable<T> delegate) {
        return new DelegateBuilder<T>(delegate);
    }

    @Override
    public T call() throws Exception {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return this.delegate.call();
            }
            catch (Exception e) {
                Exception lastException = e;
                Thread.sleep(this.sleep.toMillis());
                if (System.currentTimeMillis() - start < this.timeout.toMillis()) continue;
                throw lastException;
            }
            break;
        }
    }

    public static class RetryCallableBuilder<T> {
        private final Callable<T> delegate;
        private final Duration sleep;

        public RetryCallableBuilder(Callable<T> delegate, Duration sleep) {
            this.delegate = delegate;
            this.sleep = sleep;
        }

        public RetryCallable<T> timeout(Duration timeout) {
            return new RetryCallable<T>(this.delegate, this.sleep, timeout);
        }
    }

    public static class DelegateBuilder<T> {
        private final Callable<T> delegate;

        public DelegateBuilder(Callable<T> delegate) {
            this.delegate = delegate;
        }

        public RetryCallableBuilder<T> sleep(Duration sleep) {
            return new RetryCallableBuilder<T>(this.delegate, sleep);
        }
    }
}

