/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.query.journal.redis;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.NoOffset$;
import akka.persistence.query.Offset;
import akka.persistence.query.Sequence;
import akka.persistence.query.journal.redis.CurrentPersistenceIdsSource;
import akka.persistence.query.journal.redis.EventsByPersistenceIdSource;
import akka.persistence.query.journal.redis.EventsByTagSource;
import akka.persistence.query.journal.redis.PersistenceIdsSource;
import akka.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.CurrentEventsByTagQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.EventsByTagQuery;
import akka.persistence.query.scaladsl.PersistenceIdsQuery;
import akka.persistence.redis.RedisUtils$;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.config.Config;
import redis.RedisClient;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u00015\u0011\u0001cU2bY\u0006\u0014V-\u00193K_V\u0014h.\u00197\u000b\u0005\r!\u0011!\u0002:fI&\u001c(BA\u0003\u0007\u0003\u001dQw.\u001e:oC2T!a\u0002\u0005\u0002\u000bE,XM]=\u000b\u0005%Q\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aC\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0013\u0001qACG\u000f!G\u0019J\u0003CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A1oY1mC\u0012\u001cH.\u0003\u0002\u001a-\tY!+Z1e\u0015>,(O\\1m!\t)2$\u0003\u0002\u001d-\t\u0001RI^3oiN\u0014\u0015\u0010V1h#V,'/\u001f\t\u0003+yI!a\b\f\u00035\u00153XM\u001c;t\u0005f\u0004VM]:jgR,gnY3JIF+XM]=\u0011\u0005U\t\u0013B\u0001\u0012\u0017\u0005M\u0001VM]:jgR,gnY3JIN\fV/\u001a:z!\t)B%\u0003\u0002&-\tQ2)\u001e:sK:$\b+\u001a:tSN$XM\\2f\u0013\u0012\u001c\u0018+^3ssB\u0011QcJ\u0005\u0003QY\u0011\u0011eQ;se\u0016tG/\u0012<f]R\u001c()\u001f)feNL7\u000f^3oG\u0016LE-U;fef\u0004\"!\u0006\u0016\n\u0005-2\"aF\"veJ,g\u000e^#wK:$8OQ=UC\u001e\fV/\u001a:z\u0011!i\u0003A!A!\u0002\u0013q\u0013AB:zgR,W\u000e\u0005\u00020e5\t\u0001G\u0003\u00022\u0015\u0005)\u0011m\u0019;pe&\u00111\u0007\r\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005!1m\u001c8g!\t9d(D\u00019\u0015\tI$(\u0001\u0004d_:4\u0017n\u001a\u0006\u0003wq\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002{\u0005\u00191m\\7\n\u0005}B$AB\"p]\u001aLw\r\u0003\u0004B\u0001\u0011\u0005!AQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\t!\u0001C\u0003.\u0001\u0002\u0007a\u0006C\u00036\u0001\u0002\u0007a\u0007C\u0004\u0004\u0001\t\u0007I\u0011\u0001%\u0016\u0003%\u0003\"A\u0013'\u000e\u0003-S\u0011aA\u0005\u0003\u001b.\u00131BU3eSN\u001cE.[3oi\"1q\n\u0001Q\u0001\n%\u000baA]3eSN\u0004\u0003\"B)\u0001\t\u0003\u0011\u0016A\u00049feNL7\u000f^3oG\u0016LEm\u001d\u000b\u0002'B!A\u000b\u0017.f\u001b\u0005)&BA\fW\u0015\t9&\"\u0001\u0004tiJ,\u0017-\\\u0005\u00033V\u0013aaU8ve\u000e,\u0007CA.c\u001d\ta\u0006\r\u0005\u0002^!5\taL\u0003\u0002`\u0019\u00051AH]8pizJ!!\u0019\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CB\u0001\"AZ4\u000e\u0003)I!\u0001\u001b\u0006\u0003\u000f9{G/V:fI\")!\u000e\u0001C\u0001%\u0006)2-\u001e:sK:$\b+\u001a:tSN$XM\\2f\u0013\u0012\u001c\b\"\u00027\u0001\t\u0003i\u0017!F3wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u000b\u0005]N,(\u0010\u0005\u0003U1>,\u0007C\u00019r\u001b\u00051\u0011B\u0001:\u0007\u00055)e/\u001a8u\u000b:4X\r\\8qK\")Ao\u001ba\u00015\u0006i\u0001/\u001a:tSN$XM\\2f\u0013\u0012DQA^6A\u0002]\faB\u001a:p[N+\u0017/^3oG\u0016t%\u000f\u0005\u0002\u0010q&\u0011\u0011\u0010\u0005\u0002\u0005\u0019>tw\rC\u0003|W\u0002\u0007q/\u0001\u0007u_N+\u0017/^3oG\u0016t%\u000fC\u0003~\u0001\u0011\u0005a0\u0001\u000fdkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z!\u0016\u00148/[:uK:\u001cW-\u00133\u0015\r9|\u0018\u0011AA\u0002\u0011\u0015!H\u00101\u0001[\u0011\u00151H\u00101\u0001x\u0011\u0015YH\u00101\u0001x\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t1\"\u001a<f]R\u001c()\u001f+bOR)a.a\u0003\u0002\u0010!9\u0011QBA\u0003\u0001\u0004Q\u0016a\u0001;bO\"A\u0011\u0011CA\u0003\u0001\u0004\t\u0019\"\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0004a\u0006U\u0011bAA\f\r\t1qJ\u001a4tKRDq!a\u0007\u0001\t\u0003\ti\"\u0001\ndkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z)\u0006<G#\u00028\u0002 \u0005\u0005\u0002bBA\u0007\u00033\u0001\rA\u0017\u0005\t\u0003#\tI\u00021\u0001\u0002\u0014\u0001")
public class ScalaReadJournal
implements EventsByTagQuery,
EventsByPersistenceIdQuery,
PersistenceIdsQuery,
CurrentPersistenceIdsQuery,
CurrentEventsByPersistenceIdQuery,
CurrentEventsByTagQuery {
    private final ExtendedActorSystem system;
    private final Config conf;
    private final RedisClient redis;

    public RedisClient redis() {
        return this.redis;
    }

    public Source<String, NotUsed> persistenceIds() {
        return Source$.MODULE$.fromGraph((Graph)new PersistenceIdsSource(this.conf, this.redis(), (ActorSystem)this.system));
    }

    public Source<String, NotUsed> currentPersistenceIds() {
        return Source$.MODULE$.fromGraph((Graph)new CurrentPersistenceIdsSource(this.redis()));
    }

    public Source<EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdSource(this.conf, this.redis(), persistenceId, fromSequenceNr, toSequenceNr, (ActorSystem)this.system, true));
    }

    public Source<EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdSource(this.conf, this.redis(), persistenceId, fromSequenceNr, toSequenceNr, (ActorSystem)this.system, false));
    }

    public Source<EventEnvelope, NotUsed> eventsByTag(String tag, Offset offset) {
        Source source;
        Offset offset2 = offset;
        if (NoOffset$.MODULE$.equals(offset2)) {
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, 0L, (ActorSystem)this.system, true));
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            long offsetValue = sequence.value();
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, offsetValue, (ActorSystem)this.system, true));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Redis does not support ").append(offset.getClass().getName()).append(" offsets").toString());
        }
        return source;
    }

    public Source<EventEnvelope, NotUsed> currentEventsByTag(String tag, Offset offset) {
        Source source;
        Offset offset2 = offset;
        if (NoOffset$.MODULE$.equals(offset2)) {
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, 0L, (ActorSystem)this.system, false));
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            long offsetValue = sequence.value();
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, offsetValue, (ActorSystem)this.system, false));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Redis does not support ").append(offset.getClass().getName()).append(" offsets").toString());
        }
        return source;
    }

    public ScalaReadJournal(ExtendedActorSystem system, Config conf) {
        this.system = system;
        this.conf = conf;
        this.redis = RedisUtils$.MODULE$.create(conf, (ActorSystem)system);
    }
}

