/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.redis;

import akka.actor.ActorSystem;
import akka.persistence.utils.HostAndPort;
import akka.persistence.utils.HostAndPort$;
import com.typesafe.config.Config;
import java.io.Serializable;
import redis.RedisClient;
import redis.RedisClient$;
import redis.RedisDispatcher;
import redis.SentinelMonitoredRedisClient;
import redis.SentinelMonitoredRedisClient$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RedisUtils$ {
    public static RedisUtils$ MODULE$;

    static {
        new RedisUtils$();
    }

    public String host(Config conf) {
        return conf.getString("redis.host");
    }

    public int port(Config conf) {
        return conf.getInt("redis.port");
    }

    public Option<Object> database(Config conf) {
        return conf.hasPath("redis.database") ? new Some((Object)BoxesRunTime.boxToInteger((int)conf.getInt("redis.database"))) : None$.MODULE$;
    }

    public Option<String> password(Config conf) {
        return conf.hasPath("redis.password") ? new Some((Object)conf.getString("redis.password")) : None$.MODULE$;
    }

    public Seq<Tuple2<String, Object>> sentinels(Config conf) {
        return conf.hasPath("redis.sentinels") ? (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(conf.getConfigList("redis.sentinels")).asScala()).map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)c.getString("host"), (Object)BoxesRunTime.boxToInteger((int)c.getInt("port"))), Buffer$.MODULE$.canBuildFrom()) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getString("redis.sentinel-list").split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> HostAndPort$.MODULE$.apply((String)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HostAndPort.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSeq();
    }

    public RedisClient create(Config conf, ActorSystem system) {
        RedisClient redisClient;
        String string = conf.getString("redis.mode");
        if ("simple".equals(string)) {
            String x$3 = this.host(conf);
            int x$4 = this.port(conf);
            Option<Object> x$5 = this.database(conf);
            Option<String> x$6 = this.password(conf);
            String x$7 = RedisClient$.MODULE$.apply$default$5();
            Option x$8 = RedisClient$.MODULE$.apply$default$6();
            String x$9 = x$3;
            int x$10 = x$4;
            Option<String> x$11 = x$6;
            Option<Object> x$12 = x$5;
            String x$13 = x$7;
            Option x$14 = x$8;
            ActorSystem x$15 = system;
            RedisDispatcher x$16 = RedisClient$.MODULE$.apply$default$8(x$9, x$10, x$11, x$12, x$13, x$14);
            redisClient = new RedisClient(x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        } else if ("sentinel".equals(string)) {
            Seq<Tuple2<String, Object>> x$17 = this.sentinels(conf);
            String x$18 = conf.getString("redis.master");
            Option<Object> x$19 = this.database(conf);
            Option<String> x$20 = this.password(conf);
            String x$21 = SentinelMonitoredRedisClient$.MODULE$.apply$default$5();
            Seq<Tuple2<String, Object>> x$22 = x$17;
            String x$23 = x$18;
            Option<String> x$24 = x$20;
            Option<Object> x$25 = x$19;
            String x$26 = x$21;
            ActorSystem x$27 = system;
            RedisDispatcher x$28 = SentinelMonitoredRedisClient$.MODULE$.apply$default$7(x$22, x$23, x$24, x$25, x$26);
            redisClient = new SentinelMonitoredRedisClient(x$22, x$23, x$24, x$25, x$26, x$27, x$28).redisClient();
        } else {
            String arg$macro$26 = string;
            throw new Exception(new StringOps("Unsupported redis mode %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$26})));
        }
        return redisClient;
    }

    private RedisUtils$() {
        MODULE$ = this;
    }
}

