/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.snapshot.redis;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.pattern.CircuitBreaker;
import akka.persistence.Persistence;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.SnapshotSelectionCriteria$;
import akka.persistence.redis.RedisKeys$;
import akka.persistence.redis.RedisUtils$;
import akka.persistence.redis.SnapshotEntry;
import akka.persistence.redis.package$SnapshotEntrySerializer$;
import akka.persistence.serialization.Snapshot;
import akka.persistence.snapshot.SnapshotStore;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.typesafe.config.Config;
import java.io.Serializable;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.RedisClient;
import redis.api.Limit;
import redis.api.Limit$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001-\u0011!CU3eSN\u001cf.\u00199tQ>$8\u000b^8sK*\u00111\u0001B\u0001\u0006e\u0016$\u0017n\u001d\u0006\u0003\u000b\u0019\t\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003\u000f!\t1\u0002]3sg&\u001cH/\u001a8dK*\t\u0011\"\u0001\u0003bW.\f7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\ti1K\\1qg\"|Go\u0015;pe\u0016D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0005G>tg\r\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u000511m\u001c8gS\u001eT!!\b\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011aH\u0001\u0004G>l\u0017BA\u0011\u001b\u0005\u0019\u0019uN\u001c4jO\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000b]\u0011\u0003\u0019\u0001\r\t\u000b%\u0002A1\u0001\u0016\u0002\rML8\u000f^3n+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018\t\u0003\u0015\t7\r^8s\u0013\t\u0001TFA\u0006BGR|'oU=ti\u0016l\u0007\"\u0002\u001a\u0001\t\u0007\u0019\u0014AA3d+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\u000f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003sY\u0012\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0011\u001dY\u0004A1A\u0005\u0002q\nQb]3sS\u0006d\u0017N_1uS>tW#A\u001f\u0011\u0005y\u0002U\"A \u000b\u0005mB\u0011BA!@\u00055\u0019VM]5bY&T\u0018\r^5p]\"11\t\u0001Q\u0001\nu\nab]3sS\u0006d\u0017N_1uS>t\u0007\u0005C\u0003F\u0001\u0011\u0005a)A\bt]\u0006\u00048\u000f[8u)>\u0014\u0015\u0010^3t)\t9U\nE\u0002\u000e\u0011*K!!\u0013\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00055Y\u0015B\u0001'\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u000b9#\u0005\u0019A(\u0002\u0003M\u0004\"\u0001\u0015*\u000e\u0003ES!a\u000f\u0004\n\u0005M\u000b&\u0001C*oCB\u001c\bn\u001c;\t\u000bU\u0003A\u0011\u0001,\u0002#Mt\u0017\r]:i_R4%o\\7CsR,7\u000f\u0006\u0002P/\")\u0001\f\u0016a\u0001\u000f\u0006\t\u0011\rC\u0005\u0004\u0001\u0001\u0007\t\u0019!C\u00015V\t1\f\u0005\u0002]=6\tQLC\u0001\u0004\u0013\tyVLA\u0006SK\u0012L7o\u00117jK:$\b\"C1\u0001\u0001\u0004\u0005\r\u0011\"\u0001c\u0003%\u0011X\rZ5t?\u0012*\u0017\u000f\u0006\u0002dMB\u0011Q\u0002Z\u0005\u0003K:\u0011A!\u00168ji\"9q\rYA\u0001\u0002\u0004Y\u0016a\u0001=%c!I\u0011\u000e\u0001a\u0001\u0002\u0003\u0006KaW\u0001\u0007e\u0016$\u0017n\u001d\u0011\t\u000b-\u0004A\u0011\t7\u0002\u0011A\u0014Xm\u0015;beR$\u0012a\u0019\u0005\u0006]\u0002!\t\u0005\\\u0001\ta>\u001cHo\u0015;pa\")\u0001\u000f\u0001C\u0001c\u0006YA-\u001a7fi\u0016\f5/\u001f8d)\u0011\u0011X/!\u0002\u0011\u0007U\u001a8-\u0003\u0002um\t1a)\u001e;ve\u0016DQA^8A\u0002]\fQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007C\u0001=\u0000\u001d\tIX\u0010\u0005\u0002{\u001d5\t1P\u0003\u0002}\u0015\u00051AH]8pizJ!A \b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tqh\u0002C\u0004\u0002\b=\u0004\r!!\u0003\u0002\u0011\r\u0014\u0018\u000e^3sS\u0006\u0004B!a\u0003\u0002\u000e5\ta!C\u0002\u0002\u0010\u0019\u0011\u0011d\u00158baNDw\u000e^*fY\u0016\u001cG/[8o\u0007JLG/\u001a:jC\"1\u0001\u000f\u0001C\u0001\u0003'!2A]A\u000b\u0011!\t9\"!\u0005A\u0002\u0005e\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005-\u00111D\u0005\u0004\u0003;1!\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\t\u0011\u0002\\8bI\u0006\u001b\u0018P\\2\u0015\r\u0005\u0015\u00121GA\u001b!\u0011)4/a\n\u0011\u000b5\tI#!\f\n\u0007\u0005-bB\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\ty#C\u0002\u00022\u0019\u0011\u0001cU3mK\u000e$X\rZ*oCB\u001c\bn\u001c;\t\rY\fy\u00021\u0001x\u0011!\t9!a\bA\u0002\u0005%\u0001bBA\u001d\u0001\u0011\u0005\u00111H\u0001\ng\u00064X-Q:z]\u000e$RA]A\u001f\u0003\u007fA\u0001\"a\u0006\u00028\u0001\u0007\u0011\u0011\u0004\u0005\b\u000b\u0005]\u0002\u0019AA!!\ri\u00111I\u0005\u0004\u0003\u000br!aA!os\u0002")
public class RedisSnapshotStore
implements SnapshotStore {
    private final Config conf;
    private final Serialization serialization;
    private RedisClient redis;
    private final Persistence akka$persistence$snapshot$SnapshotStore$$extension;
    private final boolean akka$persistence$snapshot$SnapshotStore$$publish;
    private final CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker;
    private final PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$((SnapshotStore)this);
    }

    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return SnapshotStore.receivePluginInternal$((SnapshotStore)this);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
        Actor.aroundReceive$((Actor)this, receive, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public Persistence akka$persistence$snapshot$SnapshotStore$$extension() {
        return this.akka$persistence$snapshot$SnapshotStore$$extension;
    }

    public boolean akka$persistence$snapshot$SnapshotStore$$publish() {
        return this.akka$persistence$snapshot$SnapshotStore$$publish;
    }

    public CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker() {
        return this.akka$persistence$snapshot$SnapshotStore$$breaker;
    }

    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ActorSystem system() {
        return this.context().system();
    }

    public ExecutionContextExecutor ec() {
        return this.context().system().dispatcher();
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public byte[] snapshotToBytes(Snapshot s) {
        return this.serialization().findSerializerFor((Object)s).toBinary((Object)s);
    }

    public Snapshot snapshotFromBytes(byte[] a) {
        return (Snapshot)this.serialization().deserialize(a, Snapshot.class).get();
    }

    public RedisClient redis() {
        return this.redis;
    }

    public void redis_$eq(RedisClient x$1) {
        this.redis = x$1;
    }

    public void preStart() {
        this.redis_$eq(RedisUtils$.MODULE$.create(this.conf, this.system()));
        Actor.preStart$((Actor)this);
    }

    public void postStop() {
        try {
            this.redis().stop();
        }
        finally {
            Actor.postStop$((Actor)this);
        }
    }

    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        RedisClient qual$1 = this.redis();
        String x$5 = RedisKeys$.MODULE$.snapshotKey(persistenceId);
        Limit x$6 = new Limit((double)criteria.minSequenceNr(), Limit$.MODULE$.apply$default$2());
        Limit x$7 = new Limit((double)criteria.maxSequenceNr(), Limit$.MODULE$.apply$default$2());
        Option x$8 = qual$1.zrevrangebyscore$default$4();
        return qual$1.zrevrangebyscore(x$5, x$6, x$7, x$8, (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)seq -> {
            Seq toremove = (Seq)((TraversableLike)((TraversableLike)seq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SnapshotEntry snapshotEntry = x0$1;
                if (snapshotEntry == null) {
                    throw new MatchError((Object)snapshotEntry);
                }
                long sequenceNr = snapshotEntry.sequenceNr();
                long timestamp = snapshotEntry.timestamp();
                SnapshotMetadata snapshotMetadata = new SnapshotMetadata(persistenceId, sequenceNr, timestamp);
                return snapshotMetadata;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)criteria.matches(x$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SnapshotMetadata snapshotMetadata = x0$2;
                if (snapshotMetadata == null) {
                    throw new MatchError((Object)snapshotMetadata);
                }
                long sequenceNr = snapshotMetadata.sequenceNr();
                Future future = this.redis().zremrangebyscore(RedisKeys$.MODULE$.snapshotKey(persistenceId), new Limit((double)sequenceNr, Limit$.MODULE$.apply$default$2()), new Limit((double)sequenceNr, Limit$.MODULE$.apply$default$2()));
                return future;
            }, Seq$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence((TraversableOnce)toremove, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.ec());
        }, (ExecutionContext)this.ec()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            RedisSnapshotStore.$anonfun$deleteAsync$5(x$2);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
    }

    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        return this.redis().zremrangebyscore(RedisKeys$.MODULE$.snapshotKey(metadata.persistenceId()), new Limit((double)metadata.sequenceNr(), Limit$.MODULE$.apply$default$2()), new Limit((double)metadata.sequenceNr(), Limit$.MODULE$.apply$default$2())).map((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$3 -> {}, (ExecutionContext)this.ec());
    }

    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Future future;
        SnapshotSelectionCriteria snapshotSelectionCriteria = criteria;
        SnapshotSelectionCriteria snapshotSelectionCriteria2 = SnapshotSelectionCriteria$.MODULE$.None();
        if (!(snapshotSelectionCriteria != null ? !snapshotSelectionCriteria.equals(snapshotSelectionCriteria2) : snapshotSelectionCriteria2 != null)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            SnapshotSelectionCriteria snapshotSelectionCriteria3 = criteria;
            SnapshotSelectionCriteria snapshotSelectionCriteria4 = SnapshotSelectionCriteria$.MODULE$.Latest();
            if (!(snapshotSelectionCriteria3 != null ? !snapshotSelectionCriteria3.equals(snapshotSelectionCriteria4) : snapshotSelectionCriteria4 != null)) {
                future = this.redis().zrevrangebyscore(RedisKeys$.MODULE$.snapshotKey(persistenceId), new Limit(0.0, Limit$.MODULE$.apply$default$2()), new Limit(9.223372036854776E18, Limit$.MODULE$.apply$default$2()), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)1L))), (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    None$ none$;
                    SnapshotEntry snapshotEntry;
                    Seq seq = x0$3;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) >= 0 && (snapshotEntry = (SnapshotEntry)((SeqLike)some.get()).apply(0)) != null) {
                        long sequenceNr = snapshotEntry.sequenceNr();
                        long timestamp = snapshotEntry.timestamp();
                        ByteString snapshot = snapshotEntry.snapshot();
                        none$ = new Some((Object)new SelectedSnapshot(new SnapshotMetadata(persistenceId, sequenceNr, timestamp), this.snapshotFromBytes((byte[])snapshot.toArray(ClassTag$.MODULE$.Byte())).data()));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }, (ExecutionContext)this.ec());
            } else {
                RedisClient qual$2 = this.redis();
                String x$9 = RedisKeys$.MODULE$.snapshotKey(persistenceId);
                Limit x$10 = new Limit((double)criteria.minSequenceNr(), Limit$.MODULE$.apply$default$2());
                Limit x$11 = new Limit((double)criteria.maxSequenceNr(), Limit$.MODULE$.apply$default$2());
                Option x$12 = qual$2.zrevrangebyscore$default$4();
                future = qual$2.zrevrangebyscore(x$9, x$10, x$11, x$12, (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Seq seq = x0$4;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    Object object = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? None$.MODULE$ : ((IterableLike)seq.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                        SnapshotEntry snapshotEntry = x0$5;
                        if (snapshotEntry == null) {
                            throw new MatchError((Object)snapshotEntry);
                        }
                        long sequenceNr = snapshotEntry.sequenceNr();
                        long timestamp = snapshotEntry.timestamp();
                        ByteString snapshot = snapshotEntry.snapshot();
                        SelectedSnapshot selectedSnapshot = new SelectedSnapshot(new SnapshotMetadata(persistenceId, sequenceNr, timestamp), this.snapshotFromBytes((byte[])snapshot.toArray(ClassTag$.MODULE$.Byte())).data());
                        return selectedSnapshot;
                    }, Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)sel -> BoxesRunTime.boxToBoolean((boolean)criteria.matches(sel.metadata())));
                    return object;
                }, (ExecutionContext)this.ec());
            }
        }
        return future;
    }

    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        ByteString data = ByteString$.MODULE$.apply(this.snapshotToBytes(new Snapshot(snapshot)));
        return this.redis().zadd(RedisKeys$.MODULE$.snapshotKey(metadata.persistenceId()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)metadata.sequenceNr()), (Object)new SnapshotEntry(metadata.sequenceNr(), metadata.timestamp(), data))}), (ByteStringSerializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$4 -> {}, (ExecutionContext)this.ec());
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(Seq x$2) {
    }

    public RedisSnapshotStore(Config conf) {
        this.conf = conf;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$((SnapshotStore)this);
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
    }
}

