/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.snapshot.redis;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.pattern.CircuitBreaker;
import akka.persistence.Persistence;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.SnapshotSelectionCriteria$;
import akka.persistence.redis.RedisKeys$;
import akka.persistence.redis.RedisUtils$;
import akka.persistence.redis.SnapshotEntry;
import akka.persistence.redis.package$SnapshotEntrySerializer$;
import akka.persistence.serialization.Snapshot;
import akka.persistence.snapshot.SnapshotStore;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.typesafe.config.Config;
import java.io.Serializable;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.RedisClient;
import redis.api.Limit;
import redis.api.Limit$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\n\u0014\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u0001!\u0019\u0001\u000f\u0005\u0006\u007f\u0001!\u0019\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019q\u0005\u0001)A\u0005\u0013\")q\n\u0001C\u0001!\")a\f\u0001C\u0001?\"IA\u0003\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nQ\u0002\u0001\r\u00111A\u0005\u0002%D\u0011b\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B2\t\u000bA\u0004A\u0011I9\t\u000bI\u0004A\u0011I9\t\u000bM\u0004A\u0011\u0001;\t\rM\u0004A\u0011AA\f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\u000f\u0001\t\u0003\tYD\u0001\nSK\u0012L7o\u00158baNDw\u000e^*u_J,'B\u0001\u000b\u0016\u0003\u0015\u0011X\rZ5t\u0015\t1r#\u0001\u0005t]\u0006\u00048\u000f[8u\u0015\tA\u0012$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"\u0001\u000e\u0002\t\u0005\\7.Y\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"A\u000b\n\u0005\u0019*\"!D*oCB\u001c\bn\u001c;Ti>\u0014X-\u0001\u0003d_:4\u0007CA\u00151\u001b\u0005Q#BA\u0016-\u0003\u0019\u0019wN\u001c4jO*\u0011QFL\u0001\tif\u0004Xm]1gK*\tq&A\u0002d_6L!!\r\u0016\u0003\r\r{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011AG\u000e\t\u0003k\u0001i\u0011a\u0005\u0005\u0006O\t\u0001\r\u0001K\u0001\u0007gf\u001cH/Z7\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\r\u0002\u000b\u0005\u001cGo\u001c:\n\u0005yZ$aC!di>\u00148+_:uK6\f!!Z2\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002G\u0007\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\u0002\u001bM,'/[1mSj\fG/[8o+\u0005I\u0005C\u0001&M\u001b\u0005Y%BA$\u001a\u0013\ti5JA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u0003=\u0019h.\u00199tQ>$Hk\u001c\"zi\u0016\u001cHCA)X!\rq\"\u000bV\u0005\u0003'~\u0011Q!\u0011:sCf\u0004\"AH+\n\u0005Y{\"\u0001\u0002\"zi\u0016DQ\u0001W\u0004A\u0002e\u000b\u0011a\u001d\t\u00035rk\u0011a\u0017\u0006\u0003\u000f^I!!X.\u0003\u0011Ms\u0017\r]:i_R\f\u0011c\u001d8baNDw\u000e\u001e$s_6\u0014\u0015\u0010^3t)\tI\u0006\rC\u0003b\u0011\u0001\u0007\u0011+A\u0001b+\u0005\u0019\u0007C\u00013g\u001b\u0005)'\"\u0001\u000b\n\u0005\u001d,'a\u0003*fI&\u001c8\t\\5f]R\f\u0011B]3eSN|F%Z9\u0015\u0005)l\u0007C\u0001\u0010l\u0013\tawD\u0001\u0003V]&$\bb\u00028\u000b\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0014A\u0002:fI&\u001c\b%\u0001\u0005qe\u0016\u001cF/\u0019:u)\u0005Q\u0017\u0001\u00039pgR\u001cFo\u001c9\u0002\u0017\u0011,G.\u001a;f\u0003NLhn\u0019\u000b\u0005kb\fY\u0001E\u0002Cm*L!a^\"\u0003\r\u0019+H/\u001e:f\u0011\u0015Ih\u00021\u0001{\u00035\u0001XM]:jgR,gnY3JIB\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~?5\taP\u0003\u0002\u00007\u00051AH]8pizJ1!a\u0001 \u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111A\u0010\t\u000f\u00055a\u00021\u0001\u0002\u0010\u0005A1M]5uKJL\u0017\r\u0005\u0003\u0002\u0012\u0005MQ\"A\f\n\u0007\u0005UqCA\rT]\u0006\u00048\u000f[8u'\u0016dWm\u0019;j_:\u001c%/\u001b;fe&\fGcA;\u0002\u001a!9\u00111D\bA\u0002\u0005u\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005E\u0011qD\u0005\u0004\u0003C9\"\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b\u0003%aw.\u00193Bgft7\r\u0006\u0004\u0002(\u0005U\u0012q\u0007\t\u0005\u0005Z\fI\u0003E\u0003\u001f\u0003W\ty#C\u0002\u0002.}\u0011aa\u00149uS>t\u0007\u0003BA\t\u0003cI1!a\r\u0018\u0005A\u0019V\r\\3di\u0016$7K\\1qg\"|G\u000fC\u0003z!\u0001\u0007!\u0010C\u0004\u0002\u000eA\u0001\r!a\u0004\u0002\u0013M\fg/Z!ts:\u001cG#B;\u0002>\u0005}\u0002bBA\u000e#\u0001\u0007\u0011Q\u0004\u0005\u0007-E\u0001\r!!\u0011\u0011\u0007y\t\u0019%C\u0002\u0002F}\u00111!\u00118z\u0001")
public class RedisSnapshotStore
implements SnapshotStore {
    private final Config conf;
    private final Serialization serialization;
    private RedisClient redis;
    private final Persistence akka$persistence$snapshot$SnapshotStore$$extension;
    private final boolean akka$persistence$snapshot$SnapshotStore$$publish;
    private final CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker;
    private final PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$((SnapshotStore)this);
    }

    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return SnapshotStore.receivePluginInternal$((SnapshotStore)this);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
        Actor.aroundReceive$((Actor)this, receive, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public Persistence akka$persistence$snapshot$SnapshotStore$$extension() {
        return this.akka$persistence$snapshot$SnapshotStore$$extension;
    }

    public boolean akka$persistence$snapshot$SnapshotStore$$publish() {
        return this.akka$persistence$snapshot$SnapshotStore$$publish;
    }

    public CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker() {
        return this.akka$persistence$snapshot$SnapshotStore$$breaker;
    }

    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    public final void akka$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ActorSystem system() {
        return this.context().system();
    }

    public ExecutionContextExecutor ec() {
        return this.context().system().dispatcher();
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public byte[] snapshotToBytes(Snapshot s) {
        return this.serialization().findSerializerFor((Object)s).toBinary((Object)s);
    }

    public Snapshot snapshotFromBytes(byte[] a) {
        return (Snapshot)this.serialization().deserialize(a, Snapshot.class).get();
    }

    public RedisClient redis() {
        return this.redis;
    }

    public void redis_$eq(RedisClient x$1) {
        this.redis = x$1;
    }

    public void preStart() {
        this.redis_$eq(RedisUtils$.MODULE$.create(this.conf, this.system()));
        Actor.preStart$((Actor)this);
    }

    public void postStop() {
        try {
            this.redis().stop();
        }
        finally {
            Actor.postStop$((Actor)this);
        }
    }

    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        RedisClient qual$1 = this.redis();
        String x$1 = RedisKeys$.MODULE$.snapshotKey(persistenceId);
        Limit x$22 = new Limit((double)criteria.minSequenceNr(), Limit$.MODULE$.apply$default$2());
        Limit x$3 = new Limit((double)criteria.maxSequenceNr(), Limit$.MODULE$.apply$default$2());
        Option x$4 = qual$1.zrevrangebyscore$default$4();
        return qual$1.zrevrangebyscore(x$1, x$22, x$3, x$4, (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)seq -> {
            Seq toremove = (Seq)((TraversableLike)((TraversableLike)seq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SnapshotEntry snapshotEntry = x0$1;
                if (snapshotEntry == null) {
                    throw new MatchError((Object)snapshotEntry);
                }
                long sequenceNr = snapshotEntry.sequenceNr();
                long timestamp = snapshotEntry.timestamp();
                SnapshotMetadata snapshotMetadata = new SnapshotMetadata(persistenceId, sequenceNr, timestamp);
                return snapshotMetadata;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)criteria.matches(x$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SnapshotMetadata snapshotMetadata = x0$2;
                if (snapshotMetadata == null) {
                    throw new MatchError((Object)snapshotMetadata);
                }
                long sequenceNr = snapshotMetadata.sequenceNr();
                Future future = this.redis().zremrangebyscore(RedisKeys$.MODULE$.snapshotKey(persistenceId), new Limit((double)sequenceNr, Limit$.MODULE$.apply$default$2()), new Limit((double)sequenceNr, Limit$.MODULE$.apply$default$2()));
                return future;
            }, Seq$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence((TraversableOnce)toremove, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.ec());
        }, (ExecutionContext)this.ec()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            RedisSnapshotStore.$anonfun$deleteAsync$5(x$2);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
    }

    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        return this.redis().zremrangebyscore(RedisKeys$.MODULE$.snapshotKey(metadata.persistenceId()), new Limit((double)metadata.sequenceNr(), Limit$.MODULE$.apply$default$2()), new Limit((double)metadata.sequenceNr(), Limit$.MODULE$.apply$default$2())).map((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$3 -> {}, (ExecutionContext)this.ec());
    }

    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Future future;
        SnapshotSelectionCriteria snapshotSelectionCriteria = criteria;
        SnapshotSelectionCriteria snapshotSelectionCriteria2 = SnapshotSelectionCriteria$.MODULE$.None();
        if (!(snapshotSelectionCriteria != null ? !snapshotSelectionCriteria.equals(snapshotSelectionCriteria2) : snapshotSelectionCriteria2 != null)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            SnapshotSelectionCriteria snapshotSelectionCriteria3 = criteria;
            SnapshotSelectionCriteria snapshotSelectionCriteria4 = SnapshotSelectionCriteria$.MODULE$.Latest();
            if (!(snapshotSelectionCriteria3 != null ? !snapshotSelectionCriteria3.equals(snapshotSelectionCriteria4) : snapshotSelectionCriteria4 != null)) {
                future = this.redis().zrevrangebyscore(RedisKeys$.MODULE$.snapshotKey(persistenceId), new Limit(0.0, Limit$.MODULE$.apply$default$2()), new Limit(9.223372036854776E18, Limit$.MODULE$.apply$default$2()), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)1L))), (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    None$ none$;
                    SnapshotEntry snapshotEntry;
                    Seq seq = x0$1;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) >= 0 && (snapshotEntry = (SnapshotEntry)((SeqLike)some.get()).apply(0)) != null) {
                        long sequenceNr = snapshotEntry.sequenceNr();
                        long timestamp = snapshotEntry.timestamp();
                        ByteString snapshot = snapshotEntry.snapshot();
                        none$ = new Some((Object)new SelectedSnapshot(new SnapshotMetadata(persistenceId, sequenceNr, timestamp), this.snapshotFromBytes((byte[])snapshot.toArray(ClassTag$.MODULE$.Byte())).data()));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }, (ExecutionContext)this.ec());
            } else {
                RedisClient qual$1 = this.redis();
                String x$1 = RedisKeys$.MODULE$.snapshotKey(persistenceId);
                Limit x$2 = new Limit((double)criteria.minSequenceNr(), Limit$.MODULE$.apply$default$2());
                Limit x$3 = new Limit((double)criteria.maxSequenceNr(), Limit$.MODULE$.apply$default$2());
                Option x$4 = qual$1.zrevrangebyscore$default$4();
                future = qual$1.zrevrangebyscore(x$1, x$2, x$3, x$4, (ByteStringDeserializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Seq seq = x0$2;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    Object object = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? None$.MODULE$ : ((IterableLike)seq.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        SnapshotEntry snapshotEntry = x0$3;
                        if (snapshotEntry == null) {
                            throw new MatchError((Object)snapshotEntry);
                        }
                        long sequenceNr = snapshotEntry.sequenceNr();
                        long timestamp = snapshotEntry.timestamp();
                        ByteString snapshot = snapshotEntry.snapshot();
                        SelectedSnapshot selectedSnapshot = new SelectedSnapshot(new SnapshotMetadata(persistenceId, sequenceNr, timestamp), this.snapshotFromBytes((byte[])snapshot.toArray(ClassTag$.MODULE$.Byte())).data());
                        return selectedSnapshot;
                    }, Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)sel -> BoxesRunTime.boxToBoolean((boolean)criteria.matches(sel.metadata())));
                    return object;
                }, (ExecutionContext)this.ec());
            }
        }
        return future;
    }

    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        ByteString data = ByteString$.MODULE$.apply(this.snapshotToBytes(new Snapshot(snapshot)));
        return this.redis().zadd(RedisKeys$.MODULE$.snapshotKey(metadata.persistenceId()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)metadata.sequenceNr()), (Object)new SnapshotEntry(metadata.sequenceNr(), metadata.timestamp(), data))}), (ByteStringSerializer)package$SnapshotEntrySerializer$.MODULE$).map((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$4 -> {}, (ExecutionContext)this.ec());
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(Seq x$2) {
    }

    public RedisSnapshotStore(Config conf) {
        this.conf = conf;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$((SnapshotStore)this);
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
    }
}

