/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.redis;

import akka.actor.ActorSystem;
import akka.persistence.utils.HostAndPort;
import akka.persistence.utils.HostAndPort$;
import com.typesafe.config.Config;
import java.io.Serializable;
import redis.RedisClient;
import redis.RedisClient$;
import redis.RedisDispatcher;
import redis.SentinelMonitoredRedisClient;
import redis.SentinelMonitoredRedisClient$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RedisUtils$ {
    public static final RedisUtils$ MODULE$ = new RedisUtils$();

    public String host(Config conf) {
        return conf.getString("redis.host");
    }

    public int port(Config conf) {
        return conf.getInt("redis.port");
    }

    public Option<Object> database(Config conf) {
        return conf.hasPath("redis.database") ? new Some((Object)BoxesRunTime.boxToInteger((int)conf.getInt("redis.database"))) : None$.MODULE$;
    }

    public Option<String> password(Config conf) {
        return conf.hasPath("redis.password") ? new Some((Object)conf.getString("redis.password")) : None$.MODULE$;
    }

    public Seq<Tuple2<String, Object>> sentinels(Config conf) {
        return conf.hasPath("redis.sentinels") ? ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(conf.getConfigList("redis.sentinels")).asScala().map((Function1 & Serializable)c -> new Tuple2((Object)c.getString("host"), (Object)BoxesRunTime.boxToInteger((int)c.getInt("port"))))).toSeq() : ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getString("redis.sentinel-list").split(",")), (Function1 & Serializable)x$1 -> HostAndPort$.MODULE$.apply((String)x$1), ClassTag$.MODULE$.apply(HostAndPort.class))), (Function1 & Serializable)x$2 -> x$2.asTuple(), ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public RedisClient create(Config conf, ActorSystem system) {
        RedisClient redisClient;
        String string = conf.getString("redis.mode");
        if ("simple".equals(string)) {
            String x$1 = this.host(conf);
            int x$2 = this.port(conf);
            Option<Object> x$3 = this.database(conf);
            Option<String> x$4 = this.password(conf);
            String x$5 = RedisClient$.MODULE$.apply$default$5();
            Option x$6 = RedisClient$.MODULE$.apply$default$6();
            String x$7 = x$1;
            int x$8 = x$2;
            Option<String> x$9 = x$4;
            Option<Object> x$10 = x$3;
            String x$11 = x$5;
            Option x$12 = x$6;
            ActorSystem x$13 = system;
            RedisDispatcher x$14 = RedisClient$.MODULE$.apply$default$8(x$7, x$8, x$9, x$10, x$11, x$12);
            redisClient = new RedisClient(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
        } else if ("sentinel".equals(string)) {
            Seq<Tuple2<String, Object>> x$15 = this.sentinels(conf);
            String x$16 = conf.getString("redis.master");
            Option<Object> x$17 = this.database(conf);
            Option<String> x$18 = this.password(conf);
            String x$19 = SentinelMonitoredRedisClient$.MODULE$.apply$default$5();
            Seq<Tuple2<String, Object>> x$20 = x$15;
            String x$21 = x$16;
            Option<String> x$22 = x$18;
            Option<Object> x$23 = x$17;
            String x$24 = x$19;
            ActorSystem x$25 = system;
            RedisDispatcher x$26 = SentinelMonitoredRedisClient$.MODULE$.apply$default$7(x$20, x$21, x$22, x$23, x$24);
            redisClient = new SentinelMonitoredRedisClient(x$20, x$21, x$22, x$23, x$24, x$25, x$26).redisClient();
        } else {
            String arg$macro$1 = string;
            throw new Exception(StringOps$.MODULE$.format$extension("Unsupported redis mode %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        }
        return redisClient;
    }

    private RedisUtils$() {
    }
}

