/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.kafka.test.junit4;

import com.salesforce.kafka.test.AbstractKafkaTestResource;
import com.salesforce.kafka.test.KafkaCluster;
import com.salesforce.kafka.test.KafkaTestCluster;
import java.util.Collections;
import java.util.Properties;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedKafkaTestResource
extends AbstractKafkaTestResource<SharedKafkaTestResource>
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(SharedKafkaTestResource.class);

    public SharedKafkaTestResource() {
    }

    public SharedKafkaTestResource(Properties brokerProperties) {
        super(brokerProperties);
    }

    private void before() throws Exception {
        logger.info("Starting kafka test server");
        if (this.getKafkaCluster() != null) {
            throw new IllegalStateException("Unknown State!  Kafka Test Server already exists!");
        }
        this.setKafkaCluster((KafkaCluster)new KafkaTestCluster(this.getNumberOfBrokers(), this.getBrokerProperties(), Collections.singletonList(this.getRegisteredListener())));
        this.getKafkaCluster().start();
    }

    private void after() {
        logger.info("Shutting down kafka test server");
        if (this.getKafkaCluster() == null) {
            return;
        }
        try {
            this.getKafkaCluster().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setKafkaCluster(null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                SharedKafkaTestResource.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    SharedKafkaTestResource.this.after();
                }
            }
        };
    }
}

