/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.xfcc;

import com.salesforce.grpc.contrib.xfcc.XForwardedClientCert;
import com.salesforce.grpc.contrib.xfcc.XfccMarshaller;
import com.salesforce.servicelibs.io.grpc.Context;
import com.salesforce.servicelibs.io.grpc.Contexts;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.ServerCall;
import com.salesforce.servicelibs.io.grpc.ServerCallHandler;
import com.salesforce.servicelibs.io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.List;

public final class XfccServerInterceptor
implements ServerInterceptor {
    private static final Metadata.Key<List<XForwardedClientCert>> XFCC_METADATA_KEY = Metadata.Key.of((String)"x-forwarded-client-cert", (Metadata.AsciiMarshaller)new XfccMarshaller());

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Iterable values = headers.getAll(XFCC_METADATA_KEY);
        if (values != null) {
            ArrayList xfccs = new ArrayList();
            for (List value : values) {
                xfccs.addAll(value);
            }
            Context xfccContext = Context.current().withValue(XForwardedClientCert.XFCC_CONTEXT_KEY, xfccs);
            return Contexts.interceptCall((Context)xfccContext, call, (Metadata)headers, next);
        }
        return next.startCall(call, headers);
    }
}

