/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.util;

import com.salesforce.servicelibs.com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Writer;

public class HtmlEscaper {
    private static char[][] ESC = new char[97][];

    public static void escape(String value, Writer writer) {
        try {
            char[] chars = value.toCharArray();
            int length = chars.length;
            int start = 0;
            for (int i = 0; i < length; ++i) {
                char[] escaped;
                char c = chars[i];
                if (c > '`' || (escaped = ESC[c]) == null) continue;
                if (i > start) {
                    writer.write(chars, start, i - start);
                }
                writer.write(escaped);
                start = i + 1;
            }
            writer.write(chars, start, length - start);
        }
        catch (IOException e) {
            throw new MustacheException("Failed to encode value: " + value, e);
        }
    }

    static {
        char[] AMP = "&amp;".toCharArray();
        char[] LT = "&lt;".toCharArray();
        char[] GT = "&gt;".toCharArray();
        char[] DQ = "&quot;".toCharArray();
        char[] SQ = "&#39;".toCharArray();
        char[] BQ = "&#96;".toCharArray();
        char[] EQ = "&#61;".toCharArray();
        block9: for (int c = 0; c < ESC.length; ++c) {
            if (c <= 13) {
                HtmlEscaper.ESC[c] = ("&#" + c + ";").toCharArray();
                continue;
            }
            switch (c) {
                case 38: {
                    HtmlEscaper.ESC[c] = AMP;
                    continue block9;
                }
                case 60: {
                    HtmlEscaper.ESC[c] = LT;
                    continue block9;
                }
                case 62: {
                    HtmlEscaper.ESC[c] = GT;
                    continue block9;
                }
                case 34: {
                    HtmlEscaper.ESC[c] = DQ;
                    continue block9;
                }
                case 39: {
                    HtmlEscaper.ESC[c] = SQ;
                    continue block9;
                }
                case 61: {
                    HtmlEscaper.ESC[c] = EQ;
                    continue block9;
                }
                case 96: {
                    HtmlEscaper.ESC[c] = BQ;
                    continue block9;
                }
                default: {
                    HtmlEscaper.ESC[c] = null;
                }
            }
        }
    }
}

