/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.security.GSSAuthentication;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Immutable
public final class GSSUtils {
    private GSSUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static Subject getSubject() {
        return Subject.current();
    }

    public static byte[] getInitialData(GSSAuthentication gSSAuthentication, Subject subject) throws SQLException {
        if (subject == null) {
            return gSSAuthentication.getInitData();
        }
        GetInitialDataCallable getInitialDataCallable = new GetInitialDataCallable(gSSAuthentication);
        Subject.callAs(subject, getInitialDataCallable);
        if (getInitialDataCallable._exception != null) {
            throw getInitialDataCallable._exception;
        }
        return getInitialDataCallable._result;
    }

    public static byte[] evaluateAuthenticateReply(GSSAuthentication gSSAuthentication, Subject subject, Tracer tracer, HAuthenticationPart hAuthenticationPart) throws SQLException {
        if (subject == null) {
            return gSSAuthentication.evaluateAuthReply(tracer, hAuthenticationPart);
        }
        EvaluateAuthenticateReplyCallable evaluateAuthenticateReplyCallable = new EvaluateAuthenticateReplyCallable(gSSAuthentication, tracer, hAuthenticationPart);
        Subject.callAs(subject, evaluateAuthenticateReplyCallable);
        if (evaluateAuthenticateReplyCallable._exception != null) {
            throw evaluateAuthenticateReplyCallable._exception;
        }
        return evaluateAuthenticateReplyCallable._result;
    }

    static {
        Driver.checkJavaVersionMinimum18();
    }

    private static class GetInitialDataCallable
    implements Callable<byte[]> {
        private final GSSAuthentication _gssAuthentication;
        private byte[] _result;
        private SQLException _exception;

        private GetInitialDataCallable(GSSAuthentication gSSAuthentication) {
            this._gssAuthentication = gSSAuthentication;
        }

        @Override
        public byte[] call() {
            try {
                this._result = this._gssAuthentication.getInitData();
            }
            catch (SQLException sQLException) {
                this._exception = sQLException;
            }
            return null;
        }
    }

    private static class EvaluateAuthenticateReplyCallable
    implements Callable<byte[]> {
        private final GSSAuthentication _gssAuthentication;
        private final Tracer _tracer;
        private final HAuthenticationPart _authenticationPart;
        private byte[] _result;
        private SQLException _exception;

        private EvaluateAuthenticateReplyCallable(GSSAuthentication gSSAuthentication, Tracer tracer, HAuthenticationPart hAuthenticationPart) {
            this._gssAuthentication = gSSAuthentication;
            this._authenticationPart = hAuthenticationPart;
            this._tracer = tracer;
        }

        @Override
        public byte[] call() {
            try {
                this._result = this._gssAuthentication.evaluateAuthReply(this._tracer, this._authenticationPart);
            }
            catch (SQLException sQLException) {
                this._exception = sQLException;
            }
            return null;
        }
    }
}

