/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;

@ThreadSafe
abstract class ParameterMetaDataSapDB
extends WrapperDummy
implements ParameterMetaData {
    private final Tracer _tracer;
    private final ConnectionSapDB _connection;
    private final List<AbstractConverter> _converters;

    protected ParameterMetaDataSapDB(Tracer tracer, ConnectionSapDB connection, List<AbstractConverter> converters) {
        this._tracer = tracer;
        this._connection = connection;
        this._converters = converters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getParameterCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getParameterCount", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getParameterCount();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int isNullable(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "isNullable", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).isNullable();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isSigned(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isSigned", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).isSigned();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getPrecision(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getPrecision", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getPrecision();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getScale(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getScale", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getScale();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getParameterType(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getParameterType", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getColumnType();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getParameterTypeName(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getParameterTypeName", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getColumnTypeName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getParameterClassName(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getParameterClassName", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getColumnClassName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getParameterMode(int param) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getParameterMode", param);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(param).getParameterMode().getValue();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    protected int _getParameterCount() throws SQLException {
        return this._converters.size();
    }

    private AbstractConverter _getConverter(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._converters.size()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
        return this._converters.get(parameterIndex - 1);
    }

    AbstractConverter getConverter(int parameterIndex) throws SQLException {
        return this._getConverter(parameterIndex);
    }
}

