/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractVectorConverter;
import com.sap.db.jdbc.converters.HalfConverter;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class HalfVectorConverter
extends AbstractVectorConverter {
    protected HalfVectorConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, DataType.HALF, new HalfConverter(connection, parameterOptions, parameterMode, DataType.HALF, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel));
    }

    @Override
    protected byte[] _setValue(float[] values) throws SQLException {
        int len = values.length;
        byte[] bytes = new byte[4 + len * 2];
        ByteUtils.putInt(len, bytes, 0);
        for (int i = 0; i < len; ++i) {
            float value = values[i];
            if (Float.isNaN(value) || Float.isInfinite(value)) {
                throw HalfVectorConverter._newSetNumericValueInvalidException(String.valueOf(value));
            }
            if (value < HalfConverter.MIN_VALUE.floatValue() || value > HalfConverter.MAX_VALUE.floatValue()) {
                throw HalfVectorConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(HalfConverter.MIN_VALUE), String.valueOf(HalfConverter.MAX_VALUE));
            }
            ByteUtils.putHalf(value, bytes, 4 + i * 2);
        }
        return bytes;
    }
}

