/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.egovframework.rte.fdl.cryptography.impl.aria.CryptoPadding;
import javax.crypto.BadPaddingException;

@Immutable
class PKCS7Padding
implements CryptoPadding {
    private static final PKCS7Padding INSTANCE = new PKCS7Padding();
    private static final String NAME = "PKCS-7-Padding";

    static PKCS7Padding getInstance() {
        return INSTANCE;
    }

    private PKCS7Padding() {
    }

    @Override
    public byte[] addPadding(byte[] source, int blockSize) {
        byte[] paddingResult;
        int paddingCnt = source.length % blockSize;
        if (paddingCnt != 0) {
            byte paddingValue = (byte)(blockSize - paddingCnt);
            paddingResult = new byte[source.length + paddingValue];
            System.arraycopy(source, 0, paddingResult, 0, source.length);
            int addPaddingCnt = blockSize - paddingCnt;
            for (int i = 0; i < addPaddingCnt; ++i) {
                paddingResult[source.length + i] = paddingValue;
            }
        } else {
            paddingResult = new byte[source.length + blockSize];
            System.arraycopy(source, 0, paddingResult, 0, source.length);
            for (int i = 0; i < blockSize; ++i) {
                paddingResult[source.length + i] = (byte)blockSize;
            }
        }
        return paddingResult;
    }

    @Override
    public byte[] removePadding(byte[] source, int blockSize) throws BadPaddingException {
        int i;
        int checkLength;
        if (source.length % blockSize != 0) {
            throw new BadPaddingException("Provided block length is not a multiple of the expected block size");
        }
        boolean isPadding = true;
        int finalByte = source[source.length - 1];
        if (finalByte > blockSize) {
            throw new BadPaddingException("Invalid padding found at byte " + source.length);
        }
        int n = checkLength = finalByte == 16 ? blockSize : finalByte;
        for (i = source.length - 1; i >= source.length - checkLength; --i) {
            if (source[i] == finalByte) continue;
            isPadding = false;
            break;
        }
        if (!isPadding) {
            throw new BadPaddingException("Invalid padding found at byte " + (i + 1));
        }
        byte[] paddingResult = new byte[i + 1];
        System.arraycopy(source, 0, paddingResult, 0, i + 1);
        return paddingResult;
    }

    @Override
    public boolean entireBlockIsPadding(byte[] block, int blockSize) {
        if (block.length != blockSize) {
            return false;
        }
        boolean isPaddingBlock = true;
        for (int i = block.length - 1; i >= 0; --i) {
            if ((block[i] & 0xFF) == blockSize) continue;
            isPaddingBlock = false;
            break;
        }
        return isPaddingBlock;
    }

    static String getName() {
        return NAME;
    }

    static void print(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(data.length).append("] ");
        for (byte datum : data) {
            buffer.append(datum).append(" ");
        }
        System.out.println(buffer);
    }
}

