/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.Immutable;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

@Immutable
public enum AuthenticationMethodType {
    PASSWORD,
    PBKDF2,
    LDAP,
    SAML,
    SAPLOGON,
    JWT,
    KERBEROS,
    SESSIONCOOKIE,
    X509;

    public static final String DEFAULT_METHOD_NAMES;

    public static Set<AuthenticationMethodType> decode(String value) {
        String[] authMethodNames = value.toUpperCase(Locale.ENGLISH).split(",");
        EnumSet<AuthenticationMethodType> authMethodTypes = EnumSet.noneOf(AuthenticationMethodType.class);
        for (String authMethodName : authMethodNames) {
            try {
                AuthenticationMethodType authMethodType = AuthenticationMethodType.valueOf(authMethodName.trim());
                authMethodTypes.add(authMethodType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return authMethodTypes;
    }

    public static AuthenticationMethodType decodeMethodName(String methodNameFromServer) {
        AuthenticationMethodType authMethodType;
        switch (methodNameFromServer) {
            case "SCRAMSHA256": {
                authMethodType = PASSWORD;
                break;
            }
            case "SCRAMPBKDF2SHA256": {
                authMethodType = PBKDF2;
                break;
            }
            case "GSS": {
                authMethodType = KERBEROS;
                break;
            }
            default: {
                try {
                    authMethodType = AuthenticationMethodType.valueOf(methodNameFromServer.toUpperCase(Locale.ENGLISH));
                    break;
                }
                catch (IllegalArgumentException e) {
                    authMethodType = null;
                }
            }
        }
        return authMethodType;
    }

    static {
        StringBuilder builder = new StringBuilder(64);
        for (AuthenticationMethodType authMethodType : AuthenticationMethodType.values()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(authMethodType.name());
        }
        DEFAULT_METHOD_NAMES = builder.toString();
    }
}

