/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

@NotThreadSafe
class ObjectStoreFile {
    private RandomAccessFile _file;
    private FileLock _lock = null;

    ObjectStoreFile() {
    }

    boolean open(String filename, boolean create, boolean recreate) {
        File file = new File(filename);
        if (!create && !file.exists()) {
            return false;
        }
        try {
            boolean newFile;
            boolean bl = newFile = !file.exists();
            if (!newFile && recreate) {
                file.delete();
                newFile = true;
            }
            this._file = new RandomAccessFile(file, "rw");
            if (newFile) {
                FileUtils.limitAccessToReadWriteByOwner(file);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void close() {
        if (this._file != null) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._file = null;
        }
    }

    boolean position(long offset) {
        try {
            this._file.seek(offset);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    boolean write(byte[] buf) {
        try {
            this._file.write(buf);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    boolean read(byte[] buf) {
        try {
            this._file.readFully(buf);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    long getFileSize() {
        try {
            return this._file.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    boolean flush() {
        try {
            this._file.getFD().sync();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isOpen() {
        return this._file != null;
    }

    void lock() {
        try {
            this._lock = this._file.getChannel().lock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void unlock() {
        try {
            this._lock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._lock = null;
    }
}

