/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaBlob;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.AbstractLobConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.PutvalBlob;
import com.sap.db.jdbc.converters.ReaderFilter;
import com.sap.db.jdbc.converters.ReaderInputStream;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.CharsetUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Set;

@NotThreadSafe
class BlobConverter
extends AbstractLobConverter {
    protected BlobConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected AbstractGetval _getLob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(this, controller)) {
            return null;
        }
        return new HanaBlob(controller, dataPart, dataPart.getCurrentFieldOffset(), this._length);
    }

    @Override
    public PutvalBlob setString(String value) throws SQLException {
        return value != null ? BlobConverter._convertBytesToBlob(value.getBytes(), this._inputFieldPos) : null;
    }

    @Override
    public PutvalBlob setBytes(byte[] value) throws SQLException {
        return value != null ? BlobConverter._convertBytesToBlob(value, this._inputFieldPos) : null;
    }

    @Override
    public PutvalBlob setCharacterStream(Reader value, long length) throws SQLException {
        return value != null ? BlobConverter._convertInputStreamToBlob(new ReaderInputStream(length >= 0L ? new ReaderFilter(value, length) : value, 4096), -1L, this._inputFieldPos) : null;
    }

    @Override
    public PutvalBlob setAsciiStream(InputStream value, long length) throws SQLException {
        return value != null ? BlobConverter._convertInputStreamToBlob(new ReaderInputStream(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, CharsetUtils.ISO_8859_1), 4096), -1L, this._inputFieldPos) : null;
    }

    @Override
    public PutvalBlob setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? BlobConverter._convertInputStreamToBlob(value, length, this._inputFieldPos) : null;
    }

    @Override
    public Blob getBlob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? (Blob)((Object)getval) : null;
    }

    @Override
    public PutvalBlob setBlob(Blob value) throws SQLException {
        return value != null ? BlobConverter._convertBlobToBlob(value, this._inputFieldPos) : null;
    }
}

