/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.AbstractLobConverter;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.CharsetUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

@Immutable
public final class ServerConverter {
    private ServerConverter() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static int getServerInputArgLength(ServerInputArg serverInputArg) throws SQLException {
        if (serverInputArg == null) {
            return 0;
        }
        int len = serverInputArg._value == null ? 1 : ServerConverter._getNonNullServerInputArgLength(serverInputArg);
        return len;
    }

    public static int putServerInputArg(HDataPart dataPart, ServerInputArg serverInputArg) throws SQLException {
        if (serverInputArg == null) {
            return 0;
        }
        int len = serverInputArg._value == null ? dataPart.putNull(serverInputArg._dataType) : ServerConverter._putNonNullServerInputArg(dataPart, serverInputArg);
        return len;
    }

    public static ServerInputArg cloneServerInputArgForBatch(ServerInputArg serverInputArg) throws SQLException {
        if (serverInputArg == null) {
            return null;
        }
        ServerInputArg ret = serverInputArg._value == null ? serverInputArg : ServerConverter._cloneNonNullServerInputArgForBatch(serverInputArg);
        return ret;
    }

    private static int _getNonNullServerInputArgLength(ServerInputArg serverInputArg) throws SQLException {
        switch (serverInputArg._dataType) {
            case BOOLEAN: {
                return 2;
            }
            case SMALLINT: {
                return 3;
            }
            case INT: {
                return 5;
            }
            case BIGINT: {
                return 9;
            }
            case REAL: {
                return 5;
            }
            case DOUBLE: {
                return 9;
            }
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)serverInputArg._value;
                if (ServerConverter._convertBigDecimalToString(bd)) {
                    String s = bd.toPlainString();
                    int dataLen = Cesu8Utils.getByteLength(s);
                    int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
                    return dataLen + dataLengthIndicatorLen + 1;
                }
                return 17;
            }
            case DAYDATE: {
                return 5;
            }
            case SECONDTIME: {
                return 5;
            }
            case LONGDATE: {
                return 9;
            }
            case STRING: {
                int dataLen = Cesu8Utils.getByteLength((String)serverInputArg._value);
                int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
                return dataLen + dataLengthIndicatorLen + 1;
            }
            case BINARY: {
                int dataLen = ((byte[])serverInputArg._value).length;
                int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
                return dataLen + dataLengthIndicatorLen + 1;
            }
            case CLOB: 
            case NCLOB: 
            case BLOB: {
                return 10;
            }
        }
        throw SQLExceptionSapDB.newInstance("error.noconverter", serverInputArg._dataType.getDisplayName());
    }

    private static int _putNonNullServerInputArg(HDataPart dataPart, ServerInputArg serverInputArg) throws SQLException {
        switch (serverInputArg._dataType) {
            case BOOLEAN: {
                return dataPart.putBooleanAsBoolean((Boolean)serverInputArg._value);
            }
            case SMALLINT: {
                return dataPart.putShortAsSmallInt((Short)serverInputArg._value);
            }
            case INT: {
                return dataPart.putIntAsInt((Integer)serverInputArg._value);
            }
            case BIGINT: {
                return dataPart.putLongAsBigInt((Long)serverInputArg._value);
            }
            case REAL: {
                return dataPart.putFloatAsReal(((Float)serverInputArg._value).floatValue());
            }
            case DOUBLE: {
                return dataPart.putDoubleAsDouble((Double)serverInputArg._value);
            }
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)serverInputArg._value;
                if (ServerConverter._convertBigDecimalToString(bd)) {
                    String s = bd.toPlainString();
                    return dataPart.putStringAsString(s);
                }
                return dataPart.putBigDecimalAsDecimal(bd);
            }
            case DAYDATE: {
                return dataPart.putIntAsDayDate((Integer)serverInputArg._value);
            }
            case SECONDTIME: {
                return dataPart.putIntAsSecondTime((Integer)serverInputArg._value);
            }
            case LONGDATE: {
                return dataPart.putLongAsLongDate((Long)serverInputArg._value);
            }
            case STRING: {
                return dataPart.putStringAsString((String)serverInputArg._value);
            }
            case BINARY: {
                return dataPart.putBytesAsBinary((byte[])serverInputArg._value);
            }
            case CLOB: 
            case NCLOB: 
            case BLOB: {
                return ((AbstractPutval)serverInputArg._value).putDescriptor(true, dataPart);
            }
        }
        throw SQLExceptionSapDB.newInstance("error.noconverter", serverInputArg._dataType.getDisplayName());
    }

    private static ServerInputArg _cloneNonNullServerInputArgForBatch(ServerInputArg serverInputArg) throws SQLException {
        switch (serverInputArg._dataType) {
            case BOOLEAN: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case REAL: 
            case DOUBLE: 
            case DECIMAL: 
            case DAYDATE: 
            case SECONDTIME: 
            case LONGDATE: 
            case STRING: 
            case BINARY: {
                return serverInputArg;
            }
            case CLOB: 
            case NCLOB: 
            case BLOB: {
                return new ServerInputArg(serverInputArg._dataType, ((AbstractPutval)serverInputArg._value).cloneForBatch());
            }
        }
        throw SQLExceptionSapDB.newInstance("error.noconverter", serverInputArg._dataType.getDisplayName());
    }

    private static boolean _convertBigDecimalToString(BigDecimal bigDecimal) {
        return bigDecimal != null && bigDecimal.precision() > 33;
    }

    public static class ServerInputArg {
        public final DataType _dataType;
        public final Object _value;

        public static ServerInputArg newNull(int sqlType) {
            return new ServerInputArg(ServerInputArg._getNullValueDataTypeForSQLType(sqlType), null);
        }

        public static ServerInputArg newObject(Object x, TimeZone timeZone) throws SQLException {
            if (x == null) {
                return ServerInputArg.newNull(1111);
            }
            if (x instanceof Boolean) {
                return ServerInputArg.newBoolean((Boolean)x);
            }
            if (x instanceof Byte) {
                return ServerInputArg.newByte((Byte)x);
            }
            if (x instanceof Short) {
                return ServerInputArg.newShort((Short)x);
            }
            if (x instanceof Integer) {
                return ServerInputArg.newInt((Integer)x);
            }
            if (x instanceof Long) {
                return ServerInputArg.newLong((Long)x);
            }
            if (x instanceof Float) {
                return ServerInputArg.newFloat(((Float)x).floatValue());
            }
            if (x instanceof Double) {
                return ServerInputArg.newDouble((Double)x);
            }
            if (x instanceof BigDecimal) {
                return ServerInputArg.newBigDecimal((BigDecimal)x);
            }
            if (x instanceof Date) {
                return ServerInputArg.newDate((Date)x, null, timeZone);
            }
            if (x instanceof Time) {
                return ServerInputArg.newTime((Time)x, null, timeZone);
            }
            if (x instanceof Timestamp) {
                return ServerInputArg.newTimestamp((Timestamp)x, null, timeZone);
            }
            if (x instanceof java.util.Date) {
                return ServerInputArg.newDate(new Date(((java.util.Date)x).getTime()), null, timeZone);
            }
            if (x instanceof String) {
                return ServerInputArg.newString((String)x);
            }
            if (x instanceof byte[]) {
                return ServerInputArg.newBytes((byte[])x);
            }
            if (x instanceof char[]) {
                return ServerInputArg.newString(new String((char[])x));
            }
            return ServerInputArg.newString(x.toString());
        }

        public static ServerInputArg newBoolean(boolean x) {
            return new ServerInputArg(DataType.BOOLEAN, x);
        }

        public static ServerInputArg newByte(byte x) {
            return new ServerInputArg(DataType.SMALLINT, x);
        }

        public static ServerInputArg newShort(short x) {
            return new ServerInputArg(DataType.SMALLINT, x);
        }

        public static ServerInputArg newInt(int x) {
            return new ServerInputArg(DataType.INT, x);
        }

        public static ServerInputArg newLong(long x) {
            return new ServerInputArg(DataType.BIGINT, x);
        }

        public static ServerInputArg newFloat(float x) {
            return new ServerInputArg(DataType.REAL, Float.valueOf(x));
        }

        public static ServerInputArg newDouble(double x) {
            return new ServerInputArg(DataType.DOUBLE, x);
        }

        public static ServerInputArg newBigDecimal(BigDecimal x) {
            return new ServerInputArg(DataType.DECIMAL, x);
        }

        public static ServerInputArg newDate(Date x, Calendar cal, TimeZone timeZone) throws SQLException {
            if (x == null) {
                return new ServerInputArg(DataType.DATE, null);
            }
            return new ServerInputArg(DataType.DAYDATE, AbstractDateTimeConverter._convertMillisecondsToDayDate(x.getTime(), cal, timeZone));
        }

        public static ServerInputArg newTime(Time x, Calendar cal, TimeZone timeZone) throws SQLException {
            if (x == null) {
                return new ServerInputArg(DataType.TIME, null);
            }
            return new ServerInputArg(DataType.SECONDTIME, AbstractDateTimeConverter._convertMillisecondsToSecondTime(x.getTime(), cal, timeZone));
        }

        public static ServerInputArg newTimestamp(Timestamp x, Calendar cal, TimeZone timeZone) throws SQLException {
            if (x == null) {
                return new ServerInputArg(DataType.TIMESTAMP, null);
            }
            return new ServerInputArg(DataType.LONGDATE, AbstractDateTimeConverter._convertMillisecondsAndNanosecondsToLongDate(x.getTime(), x.getNanos(), cal, timeZone));
        }

        public static ServerInputArg newString(String x) {
            return new ServerInputArg(DataType.STRING, x);
        }

        public static ServerInputArg newBytes(byte[] x) {
            return new ServerInputArg(DataType.BINARY, x != null ? (byte[])x.clone() : null);
        }

        public static ServerInputArg newCharacterStream(Reader x, long length) throws SQLException {
            return new ServerInputArg(DataType.STRING, x != null ? AbstractConverter._convertReaderToString(x, length) : null);
        }

        public static ServerInputArg newAsciiStream(InputStream x, long length) throws SQLException {
            return new ServerInputArg(DataType.STRING, x != null ? AbstractConverter._convertReaderToString(new InputStreamReader(length >= 0L ? new InputStreamFilter(x, length) : x, CharsetUtils.ISO_8859_1), -1L) : null);
        }

        public static ServerInputArg newBinaryStream(InputStream x, long length) throws SQLException {
            return new ServerInputArg(DataType.BINARY, x != null ? AbstractConverter._convertInputStreamToBytes(x, length) : null);
        }

        public static ServerInputArg newUnicodeStream(InputStream x) throws SQLException {
            throw SQLExceptionSapDB.newInstance("error.conversion.javasql", "unknown", "java.io.InputStream");
        }

        public static ServerInputArg newClob(Clob x, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.CLOB, x != null ? AbstractLobConverter._convertClobToClob(x, inputFieldPos, false) : null);
        }

        public static ServerInputArg newClob(Reader x, long length, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.CLOB, x != null ? AbstractLobConverter._convertReaderToClob(x, length, inputFieldPos, false) : null);
        }

        public static ServerInputArg newNClob(NClob x, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.NCLOB, x != null ? AbstractLobConverter._convertClobToClob(x, inputFieldPos, true) : null);
        }

        public static ServerInputArg newNClob(Reader x, long length, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.NCLOB, x != null ? AbstractLobConverter._convertReaderToClob(x, length, inputFieldPos, true) : null);
        }

        public static ServerInputArg newBlob(Blob x, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.BLOB, x != null ? AbstractLobConverter._convertBlobToBlob(x, inputFieldPos) : null);
        }

        public static ServerInputArg newBlob(InputStream x, long length, int inputFieldPos) throws SQLException {
            return new ServerInputArg(DataType.BLOB, x != null ? AbstractLobConverter._convertInputStreamToBlob(x, length, inputFieldPos) : null);
        }

        private ServerInputArg(DataType dataType, Object value) {
            this._dataType = dataType;
            this._value = value;
        }

        public String toString() {
            return this._dataType.getDisplayName() + ": " + this._value;
        }

        public boolean isLOB() {
            switch (this._dataType) {
                case CLOB: 
                case NCLOB: 
                case BLOB: {
                    return true;
                }
            }
            return false;
        }

        private static DataType _getNullValueDataTypeForSQLType(int sqlType) {
            switch (sqlType) {
                case 16: {
                    return DataType.BOOLEAN;
                }
                case -7: 
                case -6: {
                    return DataType.TINYINT;
                }
                case 5: {
                    return DataType.SMALLINT;
                }
                case 4: {
                    return DataType.INT;
                }
                case -5: {
                    return DataType.BIGINT;
                }
                case 6: 
                case 7: {
                    return DataType.REAL;
                }
                case 8: {
                    return DataType.DOUBLE;
                }
                case 2: 
                case 3: {
                    return DataType.DECIMAL;
                }
                case 91: {
                    return DataType.DATE;
                }
                case 92: 
                case 2013: {
                    return DataType.TIME;
                }
                case 93: 
                case 2014: {
                    return DataType.TIMESTAMP;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return DataType.STRING;
                }
                case -4: 
                case -3: 
                case -2: {
                    return DataType.BINARY;
                }
                case 2005: {
                    return DataType.CLOB;
                }
                case 2011: {
                    return DataType.NCLOB;
                }
                case 2004: {
                    return DataType.BLOB;
                }
                case -8: 
                case 0: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2006: 
                case 2009: 
                case 2012: {
                    return DataType.STRING;
                }
            }
            return DataType.STRING;
        }
    }
}

