/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FailDotExpression;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.Arrays;
import java.util.List;

public class PairExpression
extends AbstractNode {
    private ExpressionNode key;
    private ExpressionNode value;

    public PairExpression(ExpressionNode key, ExpressionNode value, Location location) {
        super(location);
        this.key = key;
        this.value = value;
    }

    public String applyKey(Scope scope, JsonNode input) {
        JsonNode v = this.key.apply(scope, input);
        if (!v.isTextual()) {
            throw new JsltException("Object key must be string", this.location);
        }
        return v.asText();
    }

    public String getStaticKey() {
        if (!this.isKeyLiteral()) {
            throw new JsltException("INTERNAL ERROR: Attempted to get non-static key");
        }
        return this.key.apply(null, null).asText();
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        return this.value.apply(scope, input);
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        DotExpression expr = this.isKeyLiteral() ? new DotExpression(this.getStaticKey(), parent, this.location) : new FailDotExpression(this.location, "dynamic object");
        this.value.computeMatchContexts(expr);
    }

    public boolean isLiteral() {
        return this.value instanceof LiteralExpression && this.key instanceof LiteralExpression;
    }

    public boolean isKeyLiteral() {
        return this.key instanceof LiteralExpression;
    }

    @Override
    public ExpressionNode optimize() {
        this.key = this.key.optimize();
        this.value = this.value.optimize();
        return this;
    }

    @Override
    public List<ExpressionNode> getChildren() {
        return Arrays.asList(this.key, this.value);
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + '\"' + this.key + '\"' + " :");
        this.value.dump(level + 1);
    }
}

