/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.shazamcrest;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class BeanFinder {
    public static Object findBeanAt(String fieldPath, Object object) {
        try {
            return BeanFinder.findBeanAt(Arrays.asList(fieldPath.split(Pattern.quote("."))), object);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(fieldPath + " does not exist");
        }
    }

    private static Object findBeanAt(List<String> fields, Object object) {
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!BeanFinder.headOf(fields).equals(field.getName())) continue;
            try {
                if (fields.size() == 1) {
                    return field.get(object);
                }
                return BeanFinder.findBeanAt(fields.subList(1, fields.size()), field.get(object));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException();
    }

    private static String headOf(Collection<String> paths) {
        return paths.iterator().next();
    }
}

