/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.shazamcrest.matcher;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.shazam.shazamcrest.BeanFinder;
import com.shazam.shazamcrest.ComparisonDescription;
import com.shazam.shazamcrest.CyclicReferenceDetector;
import com.shazam.shazamcrest.FieldsIgnorer;
import com.shazam.shazamcrest.matcher.CustomisableMatcher;
import com.shazam.shazamcrest.matcher.GsonProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;

class DiagnosingCustomisableMatcher<T>
extends DiagnosingMatcher<T>
implements CustomisableMatcher<T> {
    private final Set<String> pathsToIgnore = new HashSet<String>();
    private final Map<String, Matcher<?>> customMatchers = new HashMap();
    protected final List<Class<?>> typesToIgnore = new ArrayList();
    protected final List<Matcher<String>> patternsToIgnore = new ArrayList<Matcher<String>>();
    protected final Set<Class<?>> circularReferenceTypes = new HashSet();
    protected final T expected;

    public DiagnosingCustomisableMatcher(T expected) {
        this.expected = expected;
    }

    public void describeTo(Description description) {
        Gson gson = GsonProvider.gson(this.typesToIgnore, this.patternsToIgnore, this.circularReferenceTypes);
        description.appendText(this.filterJson(gson, this.expected));
        for (String fieldPath : this.customMatchers.keySet()) {
            description.appendText("\nand ").appendText(fieldPath).appendText(" ").appendDescriptionOf((SelfDescribing)this.customMatchers.get(fieldPath));
        }
    }

    protected boolean matches(Object actual, Description mismatchDescription) {
        this.circularReferenceTypes.addAll(CyclicReferenceDetector.getClassesWithCircularReferences(actual));
        this.circularReferenceTypes.addAll(CyclicReferenceDetector.getClassesWithCircularReferences(this.expected));
        Gson gson = GsonProvider.gson(this.typesToIgnore, this.patternsToIgnore, this.circularReferenceTypes);
        if (!this.areCustomMatchersMatching(actual, mismatchDescription, gson)) {
            return false;
        }
        String expectedJson = this.filterJson(gson, this.expected);
        if (actual == null) {
            return this.appendMismatchDescription(mismatchDescription, expectedJson, "null", "actual was null");
        }
        String actualJson = this.filterJson(gson, actual);
        return this.assertEquals(expectedJson, actualJson, mismatchDescription);
    }

    private boolean areCustomMatchersMatching(Object actual, Description mismatchDescription, Gson gson) {
        HashMap customMatching = new HashMap();
        for (Map.Entry<String, Matcher<?>> entry : this.customMatchers.entrySet()) {
            Object object = actual == null ? null : BeanFinder.findBeanAt(entry.getKey(), actual);
            customMatching.put(object, this.customMatchers.get(entry.getKey()));
        }
        for (Map.Entry<String, Object> entry : customMatching.entrySet()) {
            String object;
            Matcher matcher = (Matcher)entry.getValue();
            if (matcher.matches((Object)(object = entry.getKey()))) continue;
            this.appendFieldPath(matcher, mismatchDescription);
            matcher.describeMismatch((Object)object, mismatchDescription);
            this.appendFieldJsonSnippet(object, mismatchDescription, gson);
            return false;
        }
        return true;
    }

    @Override
    public CustomisableMatcher<T> ignoring(String fieldPath) {
        this.pathsToIgnore.add(fieldPath);
        return this;
    }

    @Override
    public CustomisableMatcher<T> ignoring(Class<?> clazz) {
        this.typesToIgnore.add(clazz);
        return this;
    }

    @Override
    public CustomisableMatcher<T> ignoring(Matcher<String> fieldNamePattern) {
        this.patternsToIgnore.add(fieldNamePattern);
        return this;
    }

    @Override
    public <V> CustomisableMatcher<T> with(String fieldPath, Matcher<V> matcher) {
        this.customMatchers.put(fieldPath, matcher);
        return this;
    }

    protected boolean appendMismatchDescription(Description mismatchDescription, String expectedJson, String actualJson, String message) {
        if (mismatchDescription instanceof ComparisonDescription) {
            ComparisonDescription shazamMismatchDescription = (ComparisonDescription)mismatchDescription;
            shazamMismatchDescription.setComparisonFailure(true);
            shazamMismatchDescription.setExpected(expectedJson);
            shazamMismatchDescription.setActual(actualJson);
            shazamMismatchDescription.setDifferencesMessage(message);
        }
        mismatchDescription.appendText(message);
        return false;
    }

    private boolean assertEquals(String expectedJson, String actualJson, Description mismatchDescription) {
        try {
            JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (boolean)true);
        }
        catch (AssertionError e) {
            return this.appendMismatchDescription(mismatchDescription, expectedJson, actualJson, ((Throwable)((Object)e)).getMessage());
        }
        catch (JSONException e) {
            return this.appendMismatchDescription(mismatchDescription, expectedJson, actualJson, e.getMessage());
        }
        return true;
    }

    private void appendFieldJsonSnippet(Object actual, Description mismatchDescription, Gson gson) {
        JsonElement jsonTree = gson.toJsonTree(actual);
        if (!jsonTree.isJsonPrimitive() && !jsonTree.isJsonNull()) {
            mismatchDescription.appendText("\n" + gson.toJson(actual));
        }
    }

    private void appendFieldPath(Matcher<?> matcher, Description mismatchDescription) {
        for (Map.Entry<String, Matcher<?>> entry : this.customMatchers.entrySet()) {
            if (!entry.getValue().equals(matcher)) continue;
            mismatchDescription.appendText(entry.getKey()).appendText(" ");
        }
    }

    private String filterJson(Gson gson, Object object) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.pathsToIgnore);
        set.addAll(this.customMatchers.keySet());
        JsonElement filteredJson = FieldsIgnorer.findPaths(gson, object, set);
        return this.removeSetMarker(gson.toJson(filteredJson));
    }

    private String removeSetMarker(String json) {
        return json.replaceAll("!_TO_BE_SORTED_!", "");
    }
}

