/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.shazamcrest.matcher;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.graph.GraphAdapterBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.ClassUtils;
import org.hamcrest.Matcher;

class GsonProvider {
    GsonProvider() {
    }

    public static Gson gson(List<Class<?>> typesToIgnore, List<Matcher<String>> fieldsToIgnore, Set<Class<?>> circularReferenceTypes) {
        GsonBuilder gsonBuilder = GsonProvider.initGson();
        if (!circularReferenceTypes.isEmpty()) {
            GsonProvider.registerCircularReferenceTypes(circularReferenceTypes, gsonBuilder);
        }
        gsonBuilder.registerTypeAdapter(Optional.class, new OptionalSerializer());
        GsonProvider.registerSetSerialisation(gsonBuilder);
        GsonProvider.registerMapSerialisation(gsonBuilder);
        GsonProvider.markSetAndMapFields(gsonBuilder);
        GsonProvider.registerExclusionStrategies(gsonBuilder, typesToIgnore, fieldsToIgnore);
        return gsonBuilder.create();
    }

    private static void registerExclusionStrategies(GsonBuilder gsonBuilder, final List<Class<?>> typesToIgnore, final List<Matcher<String>> fieldsToIgnore) {
        if (typesToIgnore.isEmpty() && fieldsToIgnore.isEmpty()) {
            return;
        }
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                for (Matcher p : fieldsToIgnore) {
                    if (!p.matches((Object)f.getName())) continue;
                    return true;
                }
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return typesToIgnore.contains(clazz);
            }
        }});
    }

    private static void markSetAndMapFields(GsonBuilder gsonBuilder) {
        gsonBuilder.setFieldNamingStrategy(new FieldNamingStrategy(){

            public String translateName(Field f) {
                if (Set.class.isAssignableFrom(f.getType()) || Map.class.isAssignableFrom(f.getType())) {
                    return "!_TO_BE_SORTED_!" + f.getName();
                }
                return f.getName();
            }
        });
    }

    private static void registerMapSerialisation(final GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Map.class, (Object)new JsonSerializer<Map>(){

            public JsonElement serialize(Map map, Type type, JsonSerializationContext context) {
                Gson gson = gsonBuilder.create();
                ArrayListMultimap objects = GsonProvider.mapObjectsByTheirJsonRepresentation(map, gson);
                return GsonProvider.arrayOfObjectsOrderedByTheirJsonRepresentation(gson, (ArrayListMultimap<String, Object>)objects, map);
            }
        });
    }

    private static void registerSetSerialisation(final GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Set.class, (Object)new JsonSerializer<Set>(){

            public JsonElement serialize(Set set, Type type, JsonSerializationContext context) {
                Gson gson = gsonBuilder.create();
                Set orderedSet = GsonProvider.orderSetByElementsJsonRepresentation(set, gson);
                return GsonProvider.arrayOfObjectsOrderedByTheirJsonRepresentation(gson, orderedSet);
            }
        });
    }

    private static void registerCircularReferenceTypes(Set<Class<?>> circularReferenceTypes, GsonBuilder gsonBuilder) {
        GraphAdapterBuilder graphAdapterBuilder = new GraphAdapterBuilder();
        for (Class<?> circularReferenceType : circularReferenceTypes) {
            graphAdapterBuilder.addType(circularReferenceType);
        }
        graphAdapterBuilder.registerOn(gsonBuilder);
    }

    private static Set<Object> orderSetByElementsJsonRepresentation(Set set, final Gson gson) {
        TreeSet objects = Sets.newTreeSet((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return gson.toJson(o1).compareTo(gson.toJson(o2));
            }
        });
        objects.addAll(set);
        return objects;
    }

    private static ArrayListMultimap<String, Object> mapObjectsByTheirJsonRepresentation(Map map, Gson gson) {
        ArrayListMultimap objects = ArrayListMultimap.create();
        for (Map.Entry mapEntry : map.entrySet()) {
            objects.put((Object)gson.toJson(mapEntry.getKey()).concat(gson.toJson(mapEntry.getValue())), mapEntry.getKey());
        }
        return objects;
    }

    private static JsonArray arrayOfObjectsOrderedByTheirJsonRepresentation(Gson gson, Set<Object> objects) {
        JsonArray array = new JsonArray();
        for (Object object : objects) {
            array.add(gson.toJsonTree(object));
        }
        return array;
    }

    private static JsonArray arrayOfObjectsOrderedByTheirJsonRepresentation(Gson gson, ArrayListMultimap<String, Object> objects, Map map) {
        ImmutableList sortedMapKeySet = Ordering.natural().immutableSortedCopy((Iterable)objects.keySet());
        JsonArray array = new JsonArray();
        if (GsonProvider.allKeysArePrimitiveOrStringOrEnum((ImmutableList<String>)sortedMapKeySet, objects)) {
            for (String jsonRepresentation : sortedMapKeySet) {
                List objectsInTheSet = objects.get((Object)jsonRepresentation);
                for (Object objectInTheSet : objectsInTheSet) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add(String.valueOf(objectInTheSet), gson.toJsonTree(map.get(objectInTheSet)));
                    array.add((JsonElement)jsonObject);
                }
            }
        } else {
            for (String jsonRepresentation : sortedMapKeySet) {
                JsonArray keyValueArray = new JsonArray();
                List objectsInTheSet = objects.get((Object)jsonRepresentation);
                for (Object objectInTheSet : objectsInTheSet) {
                    keyValueArray.add(gson.toJsonTree(objectInTheSet));
                    keyValueArray.add(gson.toJsonTree(map.get(objectInTheSet)));
                    array.add((JsonElement)keyValueArray);
                }
            }
        }
        return array;
    }

    private static boolean allKeysArePrimitiveOrStringOrEnum(ImmutableList<String> sortedMapKeySet, ArrayListMultimap<String, Object> objects) {
        for (String jsonRepresentation : sortedMapKeySet) {
            List mapKeys = objects.get((Object)jsonRepresentation);
            for (Object object : mapKeys) {
                if (ClassUtils.isPrimitiveOrWrapper(object.getClass()) || object.getClass() == String.class || object.getClass().isEnum()) continue;
                return false;
            }
        }
        return true;
    }

    private static GsonBuilder initGson() {
        return new GsonBuilder().setPrettyPrinting();
    }

    private static class OptionalSerializer<T>
    implements JsonSerializer<Optional<T>> {
        private OptionalSerializer() {
        }

        public JsonElement serialize(Optional<T> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            result.add(context.serialize(src.orNull()));
            return result;
        }
    }
}

