/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.configuration;

import com.simpligility.maven.plugins.android.configuration.VersionElementParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;

public class RegexVersionElementParser
implements VersionElementParser {
    private Pattern namingPattern;

    public RegexVersionElementParser(String pattern) {
        this.namingPattern = Pattern.compile(pattern);
    }

    @Override
    public int[] parseVersionElements(String versionName) throws MojoExecutionException {
        Matcher matcher = this.namingPattern.matcher(versionName);
        if (!matcher.find()) {
            throw new MojoExecutionException(String.format("The version naming pattern failed to match version name: %s against %s", this.namingPattern, versionName));
        }
        int elementCount = matcher.groupCount();
        int[] result = new int[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            try {
                result[i] = Integer.valueOf(matcher.group(i + 1));
                continue;
            }
            catch (NumberFormatException ignored) {
                result[i] = 0;
            }
        }
        return result;
    }
}

