/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.DeployApk;
import com.simpligility.maven.plugins.android.configuration.ValidationResponse;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="undeploy-apk", requiresProject=false)
public class UndeployApkMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    @Parameter
    protected DeployApk deployapk;
    @Parameter(property="android.deployapk.filename")
    private File deployapkFilename;
    @PullParameter
    private File parsedFilename;
    @Parameter(property="android.deployapk.packagename")
    private String deployapkPackagename;
    @PullParameter
    private String parsedPackagename;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ValidationResponse response;
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (this.parsedFilename == null && this.parsedPackagename == null) {
            throw new MojoFailureException("\n\n One of the parameters android.deployapk.packagename or android.deployapk.filename is required. \n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.parsedPackagename)) {
            this.getLog().debug((CharSequence)("Undeploying with packagename " + this.parsedPackagename));
            this.undeployApk(this.parsedPackagename);
        }
        if ((response = DeployApk.validFileParameter(this.parsedFilename)).isValid()) {
            this.getLog().debug((CharSequence)("Undeploying with file " + this.parsedFilename));
            this.undeployApk(this.parsedFilename);
        } else {
            this.getLog().info((CharSequence)"Ignoring invalid file parameter.");
            this.getLog().debug((CharSequence)response.getMessage());
        }
    }
}

