/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rate_limits.queue;

import com.slack.api.rate_limits.RateLimiter;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.queue.QueueMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RateLimitQueue<SUPPLIER, MSG extends QueueMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitQueue.class);
    protected final ConcurrentMap<String, LinkedBlockingQueue<MSG>> methodNameToActiveQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<MSG>>();

    protected abstract RateLimiter getRateLimiter();

    protected LinkedBlockingQueue<MSG> getOrCreateActiveQueue(String methodName) {
        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.methodNameToActiveQueue.get(methodName);
        if (queue != null) {
            return queue;
        }
        LinkedBlockingQueue newQueue = new LinkedBlockingQueue();
        this.methodNameToActiveQueue.putIfAbsent(methodName, newQueue);
        return newQueue;
    }

    public synchronized SUPPLIER dequeueIfReady(String messageId, String teamId, String methodName, Map<String, String> params) {
        LinkedBlockingQueue<MSG> activeQueue = this.getOrCreateActiveQueue(methodName);
        QueueMessage message = (QueueMessage)activeQueue.peek();
        if (message == null) {
            throw new IllegalStateException("No message is found in the queue");
        }
        if (message.getId().equals(messageId) && message.getMillisToRun() <= System.currentTimeMillis()) {
            WaitTime original = message.getWaitTime();
            WaitTime latest = methodName.equals("chat.postMessage") ? this.getRateLimiter().acquireWaitTimeForChatPostMessage(teamId, params.get("channel")) : this.getRateLimiter().acquireWaitTime(teamId, methodName);
            if (log.isDebugEnabled()) {
                log.debug("Latest: {} ({} millis), original: {} ({} millis)", new Object[]{latest.getPace(), latest.getMillisToWait(), original.getPace(), original.getMillisToWait()});
            }
            if (latest.getPace() != original.getPace() && latest.getMillisToWait() > original.getMillisToWait()) {
                long newMillisToRun = System.currentTimeMillis() + latest.getMillisToWait();
                message.setMillisToRun(newMillisToRun);
                message.setWaitTime(latest);
            } else {
                Object supplier = ((QueueMessage)activeQueue.poll()).getSupplier();
                return supplier;
            }
        }
        return null;
    }

    protected abstract MSG buildNewMessage(String var1, long var2, WaitTime var4, SUPPLIER var5);

    public void enqueue(String messageId, String teamId, String methodName, Map<String, String> params, SUPPLIER methodsSupplier) throws InterruptedException {
        WaitTime waitTime = this.getRateLimiter().acquireWaitTime(teamId, methodName);
        if (methodName.equals("chat.postMessage")) {
            waitTime = this.getRateLimiter().acquireWaitTimeForChatPostMessage(teamId, params.get("channel"));
        }
        LinkedBlockingQueue<MSG> activeQueue = this.getOrCreateActiveQueue(methodName);
        long epochMillisToRun = System.currentTimeMillis() + waitTime.getMillisToWait();
        MSG message = this.buildNewMessage(messageId, epochMillisToRun, waitTime, methodsSupplier);
        activeQueue.put(message);
        if (log.isDebugEnabled()) {
            log.debug("A new message has been enqueued (id: {}, pace: {}, wait time: {})", new Object[]{((QueueMessage)message).getId(), ((QueueMessage)message).getWaitTime().getPace(), ((QueueMessage)message).getWaitTime().getMillisToWait()});
        }
    }

    public synchronized void remove(String methodName, String messageId) {
        LinkedBlockingQueue<MSG> activeQueue = this.getOrCreateActiveQueue(methodName);
        QueueMessage toRemove = null;
        for (QueueMessage message : activeQueue) {
            if (!message.getId().equals(messageId)) continue;
            toRemove = message;
            break;
        }
        activeQueue.remove(toRemove);
    }

    public Integer getCurrentActiveQueueSize(String methodNameWithSuffix) {
        LinkedBlockingQueue activeQueue = (LinkedBlockingQueue)this.methodNameToActiveQueue.get(methodNameWithSuffix);
        return activeQueue != null ? activeQueue.size() : 0;
    }
}

