/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rate_limits.metrics.impl;

import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.metrics.RequestStats;
import com.slack.api.rate_limits.queue.QueueMessage;
import com.slack.api.rate_limits.queue.RateLimitQueue;
import com.slack.api.util.thread.ExecutorServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class BaseRedisMetricsDatastore<SUPPLIER, MSG extends QueueMessage>
implements MetricsDatastore,
AutoCloseable {
    private final ScheduledExecutorService cleanerExecutor;
    private final String appName;
    private final JedisPool jedisPool;

    public BaseRedisMetricsDatastore(String appName, JedisPool jedisPool) {
        this.appName = appName;
        this.jedisPool = jedisPool;
        this.cleanerExecutor = ExecutorServiceFactory.createDaemonThreadScheduledExecutor((String)this.getThreadGroupName());
        this.cleanerExecutor.scheduleAtFixedRate(new MaintenanceJob(this), 1000L, 50L, TimeUnit.MILLISECONDS);
    }

    public abstract RateLimitQueue<SUPPLIER, MSG> getRateLimitQueue(String var1, String var2);

    public Jedis jedis() {
        return this.jedisPool.getResource();
    }

    @Override
    public void close() throws Exception {
        this.cleanerExecutor.shutdown();
        this.jedisPool.destroy();
    }

    public String getThreadGroupName() {
        return "slack-methods-metrics-redis:" + this.appName;
    }

    private void addToStatsKeyIndices(Jedis jedis, String statsKey) {
        jedis.sadd("StatsKeys", new String[]{statsKey});
    }

    private void addToLastMinuteRequestsKeyIndices(Jedis jedis, String statsKey) {
        jedis.sadd("LastMinuteRequestsKeys", new String[]{statsKey});
    }

    private void addToMessageIdsKeyIndices(Jedis jedis, String statsKey) {
        jedis.sadd("MessageIdsKeys", new String[]{statsKey});
    }

    @Override
    public Map<String, Map<String, RequestStats>> getAllStats() {
        HashMap<String, Map<String, RequestStats>> result = new HashMap<String, Map<String, RequestStats>>();
        try (Jedis jedis = this.jedis();){
            if (jedis == null) {
                HashMap<String, Map<String, RequestStats>> hashMap = result;
                return hashMap;
            }
            Set statsKeys = jedis.smembers("StatsKeys");
            if (statsKeys == null) {
                HashMap<String, Map<String, RequestStats>> hashMap = result;
                return hashMap;
            }
            for (String statsKey : statsKeys) {
                String[] elements = statsKey.split("@");
                if (elements.length < 6) continue;
                String executorName = elements[2];
                String teamId = elements[3];
                String methodName = elements[4];
                String operation = elements[5];
                if (!result.containsKey(executorName)) {
                    result.put(executorName, new HashMap());
                }
                if (!((Map)result.get(executorName)).containsKey(teamId)) {
                    ((Map)result.get(executorName)).put(teamId, new RequestStats());
                }
                RequestStats stats = (RequestStats)((Map)result.get(executorName)).get(teamId);
                String value = jedis.get(statsKey);
                if (value == null || value.trim().isEmpty()) continue;
                if (operation.equals("AllCompletedCalls")) {
                    stats.getAllCompletedCalls().put(methodName, Long.valueOf(value));
                    continue;
                }
                if (operation.equals("SuccessfulCalls")) {
                    stats.getSuccessfulCalls().put(methodName, Long.valueOf(value));
                    continue;
                }
                if (operation.equals("UnsuccessfulCalls")) {
                    stats.getUnsuccessfulCalls().put(methodName, Long.valueOf(value));
                    continue;
                }
                if (operation.equals("FailedCalls")) {
                    stats.getFailedCalls().put(methodName, Long.valueOf(value));
                    continue;
                }
                if (operation.equals("CurrentQueueSize")) {
                    stats.getCurrentQueueSize().put(methodName, Integer.valueOf(value));
                    continue;
                }
                if (operation.equals("LastMinuteRequests")) {
                    stats.getLastMinuteRequests().put(methodName, Integer.valueOf(value));
                    continue;
                }
                if (!operation.equals("RateLimitedMethods")) continue;
                stats.getRateLimitedMethods().put(methodName, Long.valueOf(value));
            }
        }
        return result;
    }

    @Override
    public RequestStats getStats(String executorName, String teamId) {
        Map<String, RequestStats> executor = this.getAllStats().get(executorName);
        return executor != null ? executor.get(teamId) : null;
    }

    private String escapeDelimiter(String executorName) {
        return executorName.replaceAll("@", "_");
    }

    private String toStatsKey(Jedis jedis, String operation, String executorName, String teamId, String methodName) {
        String key = this.escapeDelimiter(this.appName) + "@Stats@" + this.escapeDelimiter(executorName) + "@" + teamId + "@" + methodName + "@" + operation;
        this.addToStatsKeyIndices(jedis, key);
        return key;
    }

    private String toLastMinuteRequestsKey(Jedis jedis, String executorName, String teamId, String methodName) {
        String key = this.escapeDelimiter(this.appName) + "@LastMinuteRequests@" + this.escapeDelimiter(executorName) + "@" + teamId + "@" + methodName;
        this.addToLastMinuteRequestsKeyIndices(jedis, key);
        return key;
    }

    private String toWaitingMessageIdsKey(Jedis jedis, String executorName, String teamId, String methodName) {
        String key = this.escapeDelimiter(this.appName) + "@WaitingMessageIds@" + this.escapeDelimiter(executorName) + "@" + teamId + "@" + methodName;
        this.addToMessageIdsKeyIndices(jedis, key);
        return key;
    }

    @Override
    public void incrementAllCompletedCalls(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            jedis.incr(this.toStatsKey(jedis, "AllCompletedCalls", executorName, teamId, methodName));
        }
    }

    @Override
    public void incrementSuccessfulCalls(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            jedis.incr(this.toStatsKey(jedis, "SuccessfulCalls", executorName, teamId, methodName));
        }
    }

    @Override
    public void incrementUnsuccessfulCalls(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            jedis.incr(this.toStatsKey(jedis, "UnsuccessfulCalls", executorName, teamId, methodName));
        }
    }

    @Override
    public void incrementFailedCalls(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            jedis.incr(this.toStatsKey(jedis, "FailedCalls", executorName, teamId, methodName));
        }
    }

    @Override
    public void updateCurrentQueueSize(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            String key = this.toWaitingMessageIdsKey(jedis, executorName, teamId, methodName);
            Integer totalSize = Math.toIntExact(jedis.llen(key));
            RateLimitQueue<SUPPLIER, MSG> queue = this.getRateLimitQueue(executorName, teamId);
            if (queue != null) {
                totalSize = totalSize + queue.getCurrentActiveQueueSize(methodName);
            }
            this.setCurrentQueueSize(executorName, teamId, methodName, totalSize);
        }
    }

    @Override
    public void setCurrentQueueSize(String executorName, String teamId, String methodName, Integer value) {
        try (Jedis jedis = this.jedis();){
            jedis.set(this.toStatsKey(jedis, "CurrentQueueSize", executorName, teamId, methodName), "" + value);
        }
    }

    @Override
    public void updateNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            String key = this.toLastMinuteRequestsKey(jedis, executorName, teamId, methodName);
            long oneMinuteAgo = System.currentTimeMillis() - 60000L;
            for (String str : jedis.lrange(key, 0L, jedis.llen(key).longValue())) {
                long millis = Long.valueOf(str);
                if (millis >= oneMinuteAgo) continue;
                jedis.lrem(key, 1L, str);
            }
            this.setNumberOfLastMinuteRequests(executorName, teamId, methodName, Math.toIntExact(jedis.llen(key)));
        }
    }

    @Override
    public Integer getNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            String key = this.toLastMinuteRequestsKey(jedis, executorName, teamId, methodName);
            Integer n = Math.toIntExact(jedis.llen(key));
            return n;
        }
    }

    @Override
    public void setNumberOfLastMinuteRequests(String executorName, String teamId, String methodName, Integer value) {
        try (Jedis jedis = this.jedis();){
            jedis.set(this.toStatsKey(jedis, "LastMinuteRequests", executorName, teamId, methodName), "" + value);
        }
    }

    @Override
    public Long getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            String key = this.toStatsKey(jedis, "RateLimitedMethods", executorName, teamId, methodName);
            String value = jedis.get(key);
            Long l = value != null ? Long.valueOf(value) : null;
            return l;
        }
    }

    @Override
    public void setRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName, Long epochTimeMillis) {
        try (Jedis jedis = this.jedis();){
            String key = this.toStatsKey(jedis, "RateLimitedMethods", executorName, teamId, methodName);
            jedis.set(key, String.valueOf(epochTimeMillis));
        }
    }

    @Override
    public void addToLastMinuteRequests(String executorName, String teamId, String methodName, Long currentMillis) {
        try (Jedis jedis = this.jedis();){
            String key = this.toLastMinuteRequestsKey(jedis, executorName, teamId, methodName);
            jedis.rpush(key, new String[]{String.valueOf(currentMillis)});
            this.setNumberOfLastMinuteRequests(executorName, teamId, methodName, Math.toIntExact(jedis.llen(key)));
        }
    }

    @Override
    public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String methodName) {
        try (Jedis jedis = this.jedis();){
            String key = this.toLastMinuteRequestsKey(jedis, executorName, teamId, methodName);
            List values = jedis.lrange(key, 0L, jedis.llen(key) - 1L);
            LastMinuteRequests requests = new LastMinuteRequests();
            requests.addAll(values.stream().map(Long::valueOf).collect(Collectors.toList()));
            LastMinuteRequests lastMinuteRequests = requests;
            return lastMinuteRequests;
        }
    }

    @Override
    public void addToWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        try (Jedis jedis = this.jedis();){
            String key = this.toWaitingMessageIdsKey(jedis, executorName, teamId, methodName);
            jedis.rpush(key, new String[]{messageId});
        }
    }

    @Override
    public void deleteFromWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        try (Jedis jedis = this.jedis();){
            String key = this.toWaitingMessageIdsKey(jedis, executorName, teamId, methodName);
            jedis.lrem(key, 1L, messageId);
        }
    }

    public static class MaintenanceJob
    implements Runnable {
        private final BaseRedisMetricsDatastore store;

        public MaintenanceJob(BaseRedisMetricsDatastore store) {
            this.store = store;
        }

        @Override
        public void run() {
            Map<String, Map<String, RequestStats>> allStats = this.store.getAllStats();
            for (Map.Entry<String, Map<String, RequestStats>> executor : allStats.entrySet()) {
                String executorName = executor.getKey();
                for (Map.Entry<String, RequestStats> team : executor.getValue().entrySet()) {
                    String teamId = team.getKey();
                    RequestStats stats = team.getValue();
                    for (String methodName : stats.getLastMinuteRequests().keySet()) {
                        this.store.updateNumberOfLastMinuteRequests(executorName, teamId, methodName);
                    }
                    for (String methodName : stats.getCurrentQueueSize().keySet()) {
                        this.store.updateCurrentQueueSize(executorName, teamId, methodName);
                    }
                    ArrayList<String> methodNamesToRemove = new ArrayList<String>();
                    for (Map.Entry<String, Long> each : stats.getRateLimitedMethods().entrySet()) {
                        String methodName = each.getKey();
                        Long millisToRetry = each.getValue();
                        long nowMillis = System.currentTimeMillis();
                        if (millisToRetry >= nowMillis) continue;
                        methodNamesToRemove.add(methodName);
                    }
                    for (String methodName : methodNamesToRemove) {
                        stats.getRateLimitedMethods().remove(methodName);
                    }
                }
            }
        }
    }
}

