/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import com.slack.api.methods.MethodsCustomRateLimitResolver;
import com.slack.api.methods.MethodsRateLimitTier;
import com.slack.api.methods.MethodsRateLimits;
import com.slack.api.rate_limits.RateLimiter;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.WaitTimeCalculator;
import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.metrics.RequestPace;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMethodsRateLimiter
implements RateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncMethodsRateLimiter.class);
    private final MetricsDatastore metricsDatastore;
    private final MethodsCustomRateLimitResolver customRateLimitResolver;
    private final WaitTimeCalculator waitTimeCalculator;
    private final String executorName;

    public MetricsDatastore getMetricsDatastore() {
        return this.metricsDatastore;
    }

    public AsyncMethodsRateLimiter(MethodsConfig config) {
        this.metricsDatastore = config.getMetricsDatastore();
        this.customRateLimitResolver = config.getCustomRateLimitResolver();
        this.waitTimeCalculator = new MethodsWaitTimeCalculator(config);
        this.executorName = config.getExecutorName();
    }

    @Override
    public WaitTime acquireWaitTime(String teamId, String methodName) {
        Optional<Long> rateLimitedEpochMillis = this.waitTimeCalculator.getRateLimitedMethodRetryEpochMillis(this.executorName, teamId, methodName);
        if (rateLimitedEpochMillis.isPresent()) {
            long millisToWait = rateLimitedEpochMillis.get() - System.currentTimeMillis();
            return new WaitTime(millisToWait, RequestPace.RateLimited);
        }
        return this.waitTimeCalculator.calculateWaitTime(teamId, methodName, this.getAllowedRequestsPerMinute(teamId, methodName));
    }

    public int getAllowedRequestsPerMinute(String teamId, String methodName) {
        Optional<Integer> custom = this.customRateLimitResolver.getCustomAllowedRequestsPerMinute(teamId, methodName);
        if (custom.isPresent()) {
            return custom.get();
        }
        return this.waitTimeCalculator.getAllowedRequestsPerMinute(MethodsRateLimits.lookupRateLimitTier(methodName));
    }

    public int getAllowedRequestsForChatPostMessagePerMinute(String teamId, String channel) {
        Optional<Integer> custom = this.customRateLimitResolver.getCustomAllowedRequestsForChatPostMessagePerMinute(teamId, channel);
        if (custom.isPresent()) {
            return custom.get();
        }
        return this.waitTimeCalculator.getAllowedRequestsPerMinute(MethodsRateLimitTier.SpecialTier_chat_postMessage);
    }

    @Override
    public WaitTime acquireWaitTimeForChatPostMessage(String teamId, String channel) {
        return this.waitTimeCalculator.calculateWaitTimeForChatPostMessage(teamId, channel, this.getAllowedRequestsForChatPostMessagePerMinute(teamId, channel));
    }

    public static class MethodsWaitTimeCalculator
    extends WaitTimeCalculator {
        private final MethodsConfig config;

        public MethodsWaitTimeCalculator(MethodsConfig config) {
            this.config = config;
        }

        @Override
        public Optional<Long> getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String key) {
            return Optional.ofNullable(this.config.getMetricsDatastore().getRateLimitedMethodRetryEpochMillis(executorName, teamId, key));
        }

        @Override
        public Integer getNumberOfNodes() {
            return this.config.getMetricsDatastore().getNumberOfNodes();
        }

        @Override
        public String getExecutorName() {
            return this.config.getExecutorName();
        }

        @Override
        public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String key) {
            return this.config.getMetricsDatastore().getLastMinuteRequests(executorName, teamId, key);
        }
    }
}

