/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim2.impl;

import com.slack.api.RequestConfigurator;
import com.slack.api.SlackConfig;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.scim2.AsyncSCIM2Client;
import com.slack.api.scim2.SCIM2ApiRequest;
import com.slack.api.scim2.SCIM2EndpointName;
import com.slack.api.scim2.impl.AsyncRateLimitExecutor;
import com.slack.api.scim2.impl.SCIM2ClientImpl;
import com.slack.api.scim2.request.GroupsCreateRequest;
import com.slack.api.scim2.request.GroupsDeleteRequest;
import com.slack.api.scim2.request.GroupsPatchRequest;
import com.slack.api.scim2.request.GroupsReadRequest;
import com.slack.api.scim2.request.GroupsSearchRequest;
import com.slack.api.scim2.request.GroupsUpdateRequest;
import com.slack.api.scim2.request.ResourceTypesGetRequest;
import com.slack.api.scim2.request.ServiceProviderConfigsGetRequest;
import com.slack.api.scim2.request.UsersCreateRequest;
import com.slack.api.scim2.request.UsersDeleteRequest;
import com.slack.api.scim2.request.UsersPatchRequest;
import com.slack.api.scim2.request.UsersReadRequest;
import com.slack.api.scim2.request.UsersSearchRequest;
import com.slack.api.scim2.request.UsersUpdateRequest;
import com.slack.api.scim2.response.GroupsCreateResponse;
import com.slack.api.scim2.response.GroupsDeleteResponse;
import com.slack.api.scim2.response.GroupsPatchResponse;
import com.slack.api.scim2.response.GroupsReadResponse;
import com.slack.api.scim2.response.GroupsSearchResponse;
import com.slack.api.scim2.response.GroupsUpdateResponse;
import com.slack.api.scim2.response.ResourceTypesGetResponse;
import com.slack.api.scim2.response.ServiceProviderConfigsGetResponse;
import com.slack.api.scim2.response.UsersCreateResponse;
import com.slack.api.scim2.response.UsersDeleteResponse;
import com.slack.api.scim2.response.UsersPatchResponse;
import com.slack.api.scim2.response.UsersReadResponse;
import com.slack.api.scim2.response.UsersSearchResponse;
import com.slack.api.scim2.response.UsersUpdateResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSCIM2ClientImpl
implements AsyncSCIM2Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSCIM2ClientImpl.class);
    private final String token;
    private final SCIM2ClientImpl underlying;
    private final AsyncRateLimitExecutor executor;

    public AsyncSCIM2ClientImpl(String token, SCIM2ClientImpl scim, MethodsClientImpl methods, SlackConfig config) {
        this.token = token;
        this.underlying = scim;
        this.executor = AsyncRateLimitExecutor.getOrCreate(methods, config);
    }

    private String token(SCIM2ApiRequest req) {
        if (req.getToken() != null) {
            return req.getToken();
        }
        return this.token;
    }

    private Map<String, String> toMap(SCIM2ApiRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.token(req));
        return params;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.underlying.getEndpointUrlPrefix();
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.underlying.setEndpointUrlPrefix(endpointUrlPrefix);
    }

    @Override
    public CompletableFuture<ServiceProviderConfigsGetResponse> getServiceProviderConfigs(ServiceProviderConfigsGetRequest req) {
        return this.executor.execute(SCIM2EndpointName.getServiceProviderConfigs, this.toMap(req), () -> this.underlying.getServiceProviderConfigs(req));
    }

    @Override
    public CompletableFuture<ServiceProviderConfigsGetResponse> getServiceProviderConfigs(RequestConfigurator<ServiceProviderConfigsGetRequest.ServiceProviderConfigsGetRequestBuilder> req) {
        return this.getServiceProviderConfigs(req.configure(ServiceProviderConfigsGetRequest.builder()).build());
    }

    @Override
    public CompletableFuture<ResourceTypesGetResponse> getResourceTypes(ResourceTypesGetRequest req) {
        return this.executor.execute(SCIM2EndpointName.getResourceTypes, this.toMap(req), () -> this.underlying.getResourceTypes(req));
    }

    @Override
    public CompletableFuture<ResourceTypesGetResponse> getResourceTypes(RequestConfigurator<ResourceTypesGetRequest.ResourceTypesGetRequestBuilder> req) {
        return this.getResourceTypes(req.configure(ResourceTypesGetRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersSearchResponse> searchUsers(UsersSearchRequest req) {
        return this.executor.execute(SCIM2EndpointName.searchUsers, this.toMap(req), () -> this.underlying.searchUsers(req));
    }

    @Override
    public CompletableFuture<UsersSearchResponse> searchUsers(RequestConfigurator<UsersSearchRequest.UsersSearchRequestBuilder> req) {
        return this.searchUsers(req.configure(UsersSearchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersReadResponse> readUser(UsersReadRequest req) {
        return this.executor.execute(SCIM2EndpointName.readUser, this.toMap(req), () -> this.underlying.readUser(req));
    }

    @Override
    public CompletableFuture<UsersReadResponse> readUser(RequestConfigurator<UsersReadRequest.UsersReadRequestBuilder> req) {
        return this.readUser(req.configure(UsersReadRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersCreateResponse> createUser(UsersCreateRequest req) {
        return this.executor.execute(SCIM2EndpointName.createUser, this.toMap(req), () -> this.underlying.createUser(req));
    }

    @Override
    public CompletableFuture<UsersCreateResponse> createUser(RequestConfigurator<UsersCreateRequest.UsersCreateRequestBuilder> req) {
        return this.createUser(req.configure(UsersCreateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersPatchResponse> patchUser(UsersPatchRequest req) {
        return this.executor.execute(SCIM2EndpointName.patchUser, this.toMap(req), () -> this.underlying.patchUser(req));
    }

    @Override
    public CompletableFuture<UsersPatchResponse> patchUser(RequestConfigurator<UsersPatchRequest.UsersPatchRequestBuilder> req) {
        return this.patchUser(req.configure(UsersPatchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersUpdateResponse> updateUser(UsersUpdateRequest req) {
        return this.executor.execute(SCIM2EndpointName.updateUser, this.toMap(req), () -> this.underlying.updateUser(req));
    }

    @Override
    public CompletableFuture<UsersUpdateResponse> updateUser(RequestConfigurator<UsersUpdateRequest.UsersUpdateRequestBuilder> req) {
        return this.updateUser(req.configure(UsersUpdateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersDeleteResponse> deleteUser(UsersDeleteRequest req) {
        return this.executor.execute(SCIM2EndpointName.deleteUser, this.toMap(req), () -> this.underlying.deleteUser(req));
    }

    @Override
    public CompletableFuture<UsersDeleteResponse> deleteUser(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) {
        return this.deleteUser(req.configure(UsersDeleteRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsSearchResponse> searchGroups(GroupsSearchRequest req) {
        return this.executor.execute(SCIM2EndpointName.searchGroups, this.toMap(req), () -> this.underlying.searchGroups(req));
    }

    @Override
    public CompletableFuture<GroupsSearchResponse> searchGroups(RequestConfigurator<GroupsSearchRequest.GroupsSearchRequestBuilder> req) {
        return this.searchGroups(req.configure(GroupsSearchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsReadResponse> readGroup(GroupsReadRequest req) {
        return this.executor.execute(SCIM2EndpointName.readGroup, this.toMap(req), () -> this.underlying.readGroup(req));
    }

    @Override
    public CompletableFuture<GroupsReadResponse> readGroup(RequestConfigurator<GroupsReadRequest.GroupsReadRequestBuilder> req) {
        return this.readGroup(req.configure(GroupsReadRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsCreateResponse> createGroup(GroupsCreateRequest req) {
        return this.executor.execute(SCIM2EndpointName.createGroup, this.toMap(req), () -> this.underlying.createGroup(req));
    }

    @Override
    public CompletableFuture<GroupsCreateResponse> createGroup(RequestConfigurator<GroupsCreateRequest.GroupsCreateRequestBuilder> req) {
        return this.createGroup(req.configure(GroupsCreateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsPatchResponse> patchGroup(GroupsPatchRequest req) {
        return this.executor.execute(SCIM2EndpointName.patchGroup, this.toMap(req), () -> this.underlying.patchGroup(req));
    }

    @Override
    public CompletableFuture<GroupsPatchResponse> patchGroup(RequestConfigurator<GroupsPatchRequest.GroupsPatchRequestBuilder> req) {
        return this.patchGroup(req.configure(GroupsPatchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsUpdateResponse> updateGroup(GroupsUpdateRequest req) {
        return this.executor.execute(SCIM2EndpointName.updateGroup, this.toMap(req), () -> this.underlying.updateGroup(req));
    }

    @Override
    public CompletableFuture<GroupsUpdateResponse> updateGroup(RequestConfigurator<GroupsUpdateRequest.GroupsUpdateRequestBuilder> req) {
        return this.updateGroup(req.configure(GroupsUpdateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsDeleteResponse> deleteGroup(GroupsDeleteRequest req) {
        return this.executor.execute(SCIM2EndpointName.deleteGroup, this.toMap(req), () -> this.underlying.deleteGroup(req));
    }

    @Override
    public CompletableFuture<GroupsDeleteResponse> deleteGroup(RequestConfigurator<GroupsDeleteRequest.GroupsDeleteRequestBuilder> req) {
        return this.deleteGroup(req.configure(GroupsDeleteRequest.builder()).build());
    }
}

