package com.slack.api.app_backend.views.response;

import com.slack.api.model.view.View;
import com.slack.api.util.json.GsonFactory;
import lombok.*;

import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class ViewSubmissionResponse {

    private String responseAction; // push, update, errors, (no value to close)
    private View view;
    private Map<String, String> errors;

    // To override the builder generated by Lombok
    public static class ViewSubmissionResponseBuilder {
        private View view;

        public ViewSubmissionResponseBuilder viewAsString(String viewAsString) {
            View view = GsonFactory.createSnakeCase().fromJson(viewAsString, View.class);
            this.view = view;
            return this;
        }
    }
}
