/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.BackupFileCopy;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.BackupManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Properties;

public class BackupFSArchiveCopy
implements BackupFileCopy {
    public static final String CHECKSUM_KEY = "checksumAlg";
    private static final int TRANSFER_BYTES = 65536;
    private volatile Properties initProperties;
    private volatile String encryptionAlg;
    private volatile String compressionAlg;
    private volatile String checksumAlg;

    @Override
    public synchronized void initialize(File configFile) throws InterruptedException, IOException {
        if (this.initProperties != null) {
            throw new IllegalStateException("Already initialized");
        }
        Objects.requireNonNull(configFile, "configFile arg must not be null");
        Properties props = new Properties();
        try (FileInputStream configStream = new FileInputStream(configFile);){
            props.load(configStream);
        }
        this.checksumAlg = (String)props.remove(CHECKSUM_KEY);
        if (this.checksumAlg == null) {
            throw new IllegalArgumentException("checksum alg missing from:" + props);
        }
        try {
            MessageDigest.getInstance(this.checksumAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Bad checksum algorithm", e);
        }
        if (props.size() > 0) {
            throw new IllegalArgumentException("Unknown properties:" + props);
        }
        this.initProperties = props;
    }

    @Override
    public String getEncryptionAlg() {
        this.requireInitialized();
        return this.encryptionAlg;
    }

    @Override
    public String getCompressionAlg() {
        this.requireInitialized();
        return this.compressionAlg;
    }

    @Override
    public String getChecksumAlg() {
        this.requireInitialized();
        return this.checksumAlg;
    }

    @Override
    public byte[] copy(File localFile, URL archiveURL) throws InterruptedException, IOException {
        MessageDigest messageDigest;
        this.requireInitialized();
        Objects.requireNonNull(localFile, "localFile arg must not be null");
        Objects.requireNonNull(archiveURL, "archiveFile arg must not be null");
        try {
            messageDigest = MessageDigest.getInstance(this.checksumAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Bad checksum algorithm", e);
        }
        long length = localFile.length();
        File archiveFile = this.getFileFromURL(archiveURL);
        try (FileInputStream inputStream = new FileInputStream(localFile);
             FileOutputStream outputStream = new FileOutputStream(archiveFile, false);){
            int readBytes;
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            for (long bytes = length; bytes > 0L; bytes -= (long)readBytes) {
                int readSize = (int)Math.min(65536L, bytes);
                readBytes = inputStream.read(buffer.array(), 0, readSize);
                if (readBytes == -1) {
                    throw new IOException("Premature EOF. Was expecting: " + readSize);
                }
                outputStream.write(buffer.array(), 0, readSize);
                messageDigest.update(buffer.array(), 0, readBytes);
            }
        }
        BackupManager.forceFile(archiveFile.toPath());
        BackupManager.forceFile(archiveFile.getParentFile().toPath());
        return messageDigest.digest();
    }

    private File getFileFromURL(URL archiveURL) throws IOException {
        boolean created;
        if (!"file".equalsIgnoreCase(archiveURL.getProtocol())) {
            throw new IllegalArgumentException("URL scheme must be file; not" + archiveURL.getProtocol());
        }
        File archiveFile = new File(archiveURL.getFile());
        File archiveParent = archiveFile.getParentFile();
        if (!archiveParent.exists() && !(created = archiveParent.mkdirs())) {
            throw new IOException("Could not create parent directories  for " + archiveFile.getAbsolutePath());
        }
        return archiveFile;
    }

    @Override
    public byte[] checksum(URL archiveURL) throws InterruptedException, IOException {
        MessageDigest messageDigest;
        this.requireInitialized();
        Objects.requireNonNull(archiveURL, "archiveFile arg must not be null");
        if (!"file".equalsIgnoreCase(archiveURL.getProtocol())) {
            throw new IllegalArgumentException("URL scheme must be file; not" + archiveURL.getProtocol());
        }
        try {
            messageDigest = MessageDigest.getInstance(this.checksumAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        File archiveFile = new File(archiveURL.getFile());
        long length = archiveFile.length();
        try (FileInputStream inputStream = new FileInputStream(archiveFile);){
            int readBytes;
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            for (long bytes = length; bytes > 0L; bytes -= (long)readBytes) {
                int readSize = (int)Math.min(65536L, bytes);
                readBytes = inputStream.read(buffer.array(), 0, readSize);
                if (readBytes == -1) {
                    throw new IOException("Premature EOF. Was expecting: " + readSize);
                }
                messageDigest.update(buffer.array(), 0, readBytes);
            }
        }
        return messageDigest.digest();
    }

    private void requireInitialized() {
        if (this.initProperties == null) {
            throw new IllegalStateException(this.getClass().getName() + " is not initialized);");
        }
    }
}

