/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.BooleanConfigParam;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.DurationConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.config.LongConfigParam;
import com.sleepycat.je.config.ShortConfigParam;
import com.sleepycat.je.utilint.PropUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class DbConfigManager {
    private static final String PROPFILE_NAME = "je.properties";
    protected Properties props;
    private final EnvironmentConfig environmentConfig;

    public DbConfigManager(EnvironmentConfig config) {
        this.environmentConfig = config;
        this.props = config == null ? new Properties() : DbInternal.getProps(config);
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public synchronized boolean isSpecified(ConfigParam configParam) {
        return this.props.containsKey(configParam.getName());
    }

    public synchronized String get(ConfigParam configParam) {
        return DbConfigManager.getConfigParam(this.props, configParam.getName());
    }

    public synchronized String get(String configParamName) {
        return DbConfigManager.getConfigParam(this.props, configParamName);
    }

    public boolean getBoolean(BooleanConfigParam configParam) {
        String val = this.get(configParam);
        return DbConfigManager.parseBoolean(val);
    }

    public short getShort(ShortConfigParam configParam) {
        short shortValue;
        block3: {
            String val = this.get(configParam);
            shortValue = 0;
            if (val != null) {
                try {
                    shortValue = Short.parseShort(val);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return shortValue;
    }

    public int getInt(IntConfigParam configParam) {
        int intValue;
        block3: {
            String val = this.get(configParam);
            intValue = 0;
            if (val != null) {
                try {
                    intValue = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return intValue;
    }

    public long getLong(LongConfigParam configParam) {
        long longValue;
        block3: {
            String val = this.get(configParam);
            longValue = 0L;
            if (val != null) {
                try {
                    longValue = Long.parseLong(val);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return longValue;
    }

    public int getDuration(DurationConfigParam configParam) {
        int millis;
        block3: {
            String val = this.get(configParam);
            millis = 0;
            if (val != null) {
                try {
                    millis = PropUtil.parseDuration(val);
                }
                catch (IllegalArgumentException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return millis;
    }

    public long getDurationNS(DurationConfigParam configParam) {
        long nanos;
        block3: {
            String val = this.get(configParam);
            nanos = 0L;
            if (val != null) {
                try {
                    nanos = PropUtil.parseDurationNS(val);
                }
                catch (IllegalArgumentException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        return nanos;
    }

    public String getLoggingDir(String defaultDir) {
        String traceFileDir = this.get(EnvironmentParams.FILE_LOGGING_DIRECTORY);
        if (traceFileDir == null || traceFileDir.equals("")) {
            return defaultDir;
        }
        return traceFileDir;
    }

    public String getStatsDir(String defaultDir) {
        String statDir = this.get(EnvironmentParams.STATS_FILE_DIRECTORY);
        if (statDir != null && !statDir.equals("")) {
            return statDir;
        }
        String traceFileDir = this.get(EnvironmentParams.FILE_LOGGING_DIRECTORY);
        if (traceFileDir == null || traceFileDir.equals("")) {
            return defaultDir;
        }
        return traceFileDir;
    }

    public String getPrefixedFileName(String fileName) {
        String traceFilePrefix = this.get(EnvironmentParams.FILE_LOGGING_PREFIX);
        if (traceFilePrefix != null && traceFilePrefix.length() > 0) {
            return traceFilePrefix + "." + fileName;
        }
        return fileName;
    }

    public static void validateProperties(Properties props, boolean isRepConfigInstance, String configClassName) throws IllegalArgumentException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String mvParamName;
            String name = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(name);
            if (param == null && (param = EnvironmentParams.SUPPORTED_PARAMS.get(mvParamName = ConfigParam.multiValueParamName(name))) == null) {
                if (configClassName == null && !isRepConfigInstance && name.contains("je.rep.")) {
                    props.remove(name);
                    continue;
                }
                throw new IllegalArgumentException(name + " is not a valid BDBJE environment configuration");
            }
            if (configClassName != null) {
                if (isRepConfigInstance) {
                    if (!param.isForReplication()) {
                        throw new IllegalArgumentException(name + " is not a replication parameter and cannot  be set through " + configClassName);
                    }
                } else if (param.isForReplication()) {
                    throw new IllegalArgumentException(name + " is a replication parameter and cannot be set  through " + configClassName);
                }
            }
            param.validateValue(props.getProperty(name));
        }
    }

    public static void applyFileConfig(File envHome, Properties props, boolean forReplication) throws IllegalArgumentException {
        File paramFile = null;
        try {
            Properties fileProps = new Properties();
            if (envHome != null) {
                paramFile = envHome.isFile() ? envHome : new File(envHome, PROPFILE_NAME);
                FileInputStream fis = new FileInputStream(paramFile);
                fileProps.load(fis);
                fis.close();
            }
            DbConfigManager.validateProperties(fileProps, false, null);
            for (Map.Entry<Object, Object> propPair : fileProps.entrySet()) {
                String name = (String)propPair.getKey();
                String value = (String)propPair.getValue();
                DbConfigManager.setConfigParam(props, name, value, false, false, forReplication, false);
            }
        }
        catch (FileNotFoundException fileProps) {
        }
        catch (IOException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("An error occurred when reading " + paramFile);
            e2.initCause(e);
            throw e2;
        }
    }

    public static void setConfigParam(Properties props, String paramName, String value, boolean requireMutability, boolean validateValue, boolean forReplication, boolean verifyForReplication) throws IllegalArgumentException {
        boolean isMVParam = false;
        ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            String mvParamName = ConfigParam.multiValueParamName(paramName);
            param = EnvironmentParams.SUPPORTED_PARAMS.get(mvParamName);
            if (param == null || !param.isMultiValueParam()) {
                throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment parameter");
            }
            isMVParam = true;
            assert (param.isMultiValueParam());
        }
        if (verifyForReplication) {
            if (forReplication) {
                if (!param.isForReplication()) {
                    throw new IllegalArgumentException(paramName + " is not a replication parameter.");
                }
            } else if (param.isForReplication()) {
                throw new IllegalArgumentException(paramName + " is a replication parameter and cannot be  set through this configuration class.");
            }
        }
        if (requireMutability && !param.isMutable()) {
            throw new IllegalArgumentException(paramName + " is not a mutable BDBJE environment configuration");
        }
        if (isMVParam) {
            DbConfigManager.setVal(props, param, paramName, value, validateValue);
        } else {
            DbConfigManager.setVal(props, param, value, validateValue);
        }
    }

    public static String getConfigParam(Properties props, String paramName) throws IllegalArgumentException {
        boolean isMVParam = false;
        ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            String mvParamName = ConfigParam.multiValueParamName(paramName);
            param = EnvironmentParams.SUPPORTED_PARAMS.get(mvParamName);
            if (param == null) {
                throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
            }
            isMVParam = true;
            assert (param.isMultiValueParam());
        } else if (param.isMultiValueParam()) {
            throw new IllegalArgumentException("Use getMultiValueValues() to retrieve Multi-Value parameter values.");
        }
        if (isMVParam) {
            return DbConfigManager.getVal(props, param, paramName);
        }
        return DbConfigManager.getVal(props, param);
    }

    public static String getVal(Properties props, ConfigParam param) {
        String val = props.getProperty(param.getName());
        if (val == null) {
            val = param.getDefault();
        }
        return val;
    }

    public static String getVal(Properties props, ConfigParam param, String paramName) {
        String val = props.getProperty(paramName);
        if (val == null) {
            val = param.getDefault();
        }
        return val;
    }

    public static void setVal(Properties props, ConfigParam param, String val, boolean validateValue) throws IllegalArgumentException {
        if (validateValue) {
            param.validateValue(val);
        }
        props.setProperty(param.getName(), val);
    }

    public static void setVal(Properties props, ConfigParam param, String paramName, String val, boolean validateValue) throws IllegalArgumentException {
        if (validateValue) {
            param.validateValue(val);
        }
        props.setProperty(paramName, val);
    }

    public static int getIntVal(Properties props, IntConfigParam param) {
        String val = DbConfigManager.getVal(props, param);
        if (val == null) {
            throw EnvironmentFailureException.unexpectedState("No value for " + param.getName());
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw EnvironmentFailureException.unexpectedState("Bad value for " + param.getName() + ": " + e.getMessage());
        }
    }

    public static void setIntVal(Properties props, IntConfigParam param, int val, boolean validateValue) {
        DbConfigManager.setVal(props, param, Integer.toString(val), validateValue);
    }

    public static long getLongVal(Properties props, LongConfigParam param) {
        String val = DbConfigManager.getVal(props, param);
        if (val == null) {
            throw EnvironmentFailureException.unexpectedState("No value for " + param.getName());
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw EnvironmentFailureException.unexpectedState("Bad value for " + param.getName() + ": " + e.getMessage());
        }
    }

    public static boolean getBooleanVal(Properties props, BooleanConfigParam param) {
        String val = DbConfigManager.getVal(props, param);
        if (val == null) {
            throw EnvironmentFailureException.unexpectedState("No value for " + param.getName());
        }
        return DbConfigManager.parseBoolean(val);
    }

    public static void setBooleanVal(Properties props, BooleanConfigParam param, boolean val, boolean validateValue) {
        DbConfigManager.setVal(props, param, Boolean.toString(val), validateValue);
    }

    public static long getDurationVal(Properties props, DurationConfigParam param, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit argument may not be null");
        }
        String val = DbConfigManager.getVal(props, param);
        if (val == null) {
            throw EnvironmentFailureException.unexpectedState("No value for " + param.getName());
        }
        try {
            return unit.convert(PropUtil.parseDuration(val), TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException e) {
            throw EnvironmentFailureException.unexpectedState("Bad value for " + param.getName() + ": " + e.getMessage());
        }
    }

    public static void setDurationVal(Properties props, DurationConfigParam param, long val, TimeUnit unit, boolean validateValue) {
        DbConfigManager.setVal(props, param, PropUtil.formatDuration(val, unit), validateValue);
    }

    private static boolean parseBoolean(String val) {
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val.trim());
    }
}

