/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.DiskOrderedCursorProducerException;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DiskOrderedScanner;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.tree.LN;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class DiskOrderedCursorImpl {
    private int queueSize = 1000;
    private int offerTimeout;
    private final boolean keysOnly;
    private final EnvironmentImpl env;
    private final Processor processor;
    private final DiskOrderedScanner scanner;
    private final Thread producer;
    private final BlockingQueue<KeyAndData> queue;
    private final KeyAndData END_OF_QUEUE = new KeyAndData();
    private final RuntimeException SHUTDOWN_REQUESTED_EXCEPTION = new RuntimeException("Producer Thread shutdown requested");
    private boolean closed = false;
    private KeyAndData currentNode = null;

    public DiskOrderedCursorImpl(DatabaseImpl[] dbImpls, DiskOrderedCursorConfig config) {
        this.env = dbImpls[0].getEnv();
        DbConfigManager configMgr = this.env.getConfigManager();
        this.offerTimeout = configMgr.getDuration(EnvironmentParams.DOS_PRODUCER_QUEUE_TIMEOUT);
        this.keysOnly = config.getKeysOnly();
        this.queueSize = config.getQueueSize();
        if (this.keysOnly) {
            for (int i = 0; i < dbImpls.length; ++i) {
                if (this.queueSize >= dbImpls[i].getNodeMaxTreeEntries()) continue;
                this.queueSize = dbImpls[i].getNodeMaxTreeEntries();
            }
        }
        this.processor = new Processor();
        this.scanner = new DiskOrderedScanner(dbImpls, this.processor, config.getSerialDBScan(), config.getBINsOnly(), this.keysOnly, config.getCountOnly(), config.getLSNBatchSize(), config.getInternalMemoryLimit(), config.getDebug());
        this.queue = new ArrayBlockingQueue<KeyAndData>(this.queueSize);
        this.producer = new Thread(){

            @Override
            public void run() {
                try {
                    DiskOrderedCursorImpl.this.scanner.scan("DiskOrderedCursor", DiskOrderedCursorImpl.this.env.getNodeSequence().getNextDiskOrderedCursorId());
                    DiskOrderedCursorImpl.this.processor.close();
                }
                catch (Throwable T) {
                    if (T == DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION) {
                        ((DiskOrderedCursorImpl)DiskOrderedCursorImpl.this).processor.isClosed = true;
                        return;
                    }
                    DiskOrderedCursorImpl.this.processor.setException(T);
                    DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE);
                }
            }
        };
        this.producer.setName("DiskOrderedCursor Producer Thread for " + Thread.currentThread());
        this.producer.start();
    }

    public boolean isProcessorClosed() {
        return this.processor.isClosed;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.processor.setShutdown();
        this.closed = true;
    }

    public void checkEnv() {
        this.env.checkIfInvalid();
    }

    private OperationResult setData(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (foundKey != null) {
            LN.setEntry(foundKey, this.currentNode.getKey());
        }
        if (foundData != null) {
            LN.setEntry(foundData, this.currentNode.getData());
        }
        return DbInternal.makeResult(this.currentNode.getExpirationTime());
    }

    public synchronized OperationResult getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return null;
        }
        return this.setData(foundKey, foundData);
    }

    public int getCurrDb() {
        if (this.closed) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return -1;
        }
        return this.currentNode.getDbIdx();
    }

    public synchronized OperationResult getNext(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return null;
        }
        try {
            do {
                this.currentNode = this.queue.poll(1L, TimeUnit.SECONDS);
            } while (this.processor.getException() == null && this.currentNode == null);
        }
        catch (InterruptedException IE) {
            this.currentNode = this.END_OF_QUEUE;
            throw new ThreadInterruptedException(this.env, (Throwable)IE);
        }
        if (this.processor.getException() != null) {
            throw new DiskOrderedCursorProducerException("Producer Thread Failure", this.processor.getException());
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return null;
        }
        return this.setData(foundKey, foundData);
    }

    int freeQueueSlots() {
        return this.queue.remainingCapacity();
    }

    long getNumLsns() {
        return this.scanner.getNumLsns();
    }

    DiskOrderedScanner getScanner() {
        return this.scanner;
    }

    public int getNScannerIterations() {
        return this.scanner.getNIterations();
    }

    private class Processor
    implements DiskOrderedScanner.RecordProcessor {
        private Throwable exception;
        private volatile boolean shutdownNow;
        public boolean isClosed = false;

        private Processor() {
        }

        @Override
        public void process(int dbIdx, byte[] key, byte[] data, int expiration, boolean expirationInHours) {
            this.checkShutdown();
            try {
                KeyAndData e = new KeyAndData(dbIdx, key, data, expiration, expirationInHours);
                while (!DiskOrderedCursorImpl.this.queue.offer(e, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.checkShutdown();
                }
            }
            catch (InterruptedException IE) {
                this.setException(new ThreadInterruptedException(DiskOrderedCursorImpl.this.env, (Throwable)IE));
                this.setShutdown();
            }
        }

        @Override
        public boolean canProcessWithoutBlocking(int nRecords) {
            return DiskOrderedCursorImpl.this.queue.remainingCapacity() >= nRecords;
        }

        @Override
        public int getCapacity() {
            return DiskOrderedCursorImpl.this.queueSize;
        }

        void close() {
            try {
                if (!DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.setException(DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION.fillInStackTrace());
                    this.setShutdown();
                }
                this.isClosed = true;
            }
            catch (InterruptedException IE) {
                this.setException(new ThreadInterruptedException(DiskOrderedCursorImpl.this.env, (Throwable)IE));
                this.setShutdown();
            }
        }

        void setException(Throwable t) {
            this.exception = t;
        }

        private Throwable getException() {
            return this.exception;
        }

        private void setShutdown() {
            this.shutdownNow = true;
        }

        @Override
        public void checkShutdown() {
            if (this.shutdownNow) {
                throw DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION;
            }
        }
    }

    private static class KeyAndData {
        final int dbIdx;
        final byte[] key;
        final byte[] data;
        final int expiration;

        private KeyAndData() {
            this.dbIdx = -1;
            this.key = null;
            this.data = null;
            this.expiration = 0;
        }

        private KeyAndData(int dbIdx, byte[] key, byte[] data, int expiration, boolean expirationInHours) {
            this.dbIdx = dbIdx;
            this.key = key;
            this.data = data;
            this.expiration = expirationInHours ? -expiration : expiration;
        }

        private int getDbIdx() {
            return this.dbIdx;
        }

        private byte[] getKey() {
            return this.key;
        }

        private byte[] getData() {
            return this.data;
        }

        private long getExpirationTime() {
            if (this.expiration == 0) {
                return 0L;
            }
            if (this.expiration < 0) {
                return TTL.expirationToSystemTime(-this.expiration, true);
            }
            return TTL.expirationToSystemTime(this.expiration, false);
        }
    }
}

