/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.FeederFilter;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMaxZeroStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.VLSN;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class BaseProtocol
extends BinaryProtocol {
    public static final int MAX_VERSION = 9;
    static final int MIN_VERSION = 3;
    public static final int VERSION_9 = 9;
    public static final JEVersion VERSION_9_JE_VERSION = new JEVersion("18.3.4");
    public static final int VERSION_8 = 8;
    public static final JEVersion VERSION_8_JE_VERSION = new JEVersion("18.3.1");
    public static final int VERSION_7 = 7;
    public static final JEVersion VERSION_7_JE_VERSION = new JEVersion("7.5.6");
    public static final int VERSION_6 = 6;
    public static final JEVersion VERSION_6_JE_VERSION = new JEVersion("6.4.10");
    public static final int VERSION_5 = 5;
    public static final JEVersion VERSION_5_JE_VERSION = new JEVersion("6.0.1");
    static final int VERSION_4 = 4;
    public static final JEVersion VERSION_4_JE_VERSION = new JEVersion("5.0.58");
    static final int VERSION_3 = 3;
    public static final JEVersion VERSION_3_JE_VERSION = new JEVersion("4.0.50");
    protected static final short MIN_MESSAGE_OP_CODE_IN_SUBCLASS = 1024;
    protected static final short MAX_MESSAGE_OP_CODE_IN_SUBCLASS = 2047;
    public static final BinaryProtocol.MessageOp ENTRY = new BinaryProtocol.MessageOp(101, Entry.class);
    public static final BinaryProtocol.MessageOp START_STREAM = new BinaryProtocol.MessageOp(102, StartStream.class);
    public static final BinaryProtocol.MessageOp HEARTBEAT = new BinaryProtocol.MessageOp(103, Heartbeat.class);
    public static final BinaryProtocol.MessageOp HEARTBEAT_RESPONSE = new BinaryProtocol.MessageOp(104, HeartbeatResponse.class);
    public static final BinaryProtocol.MessageOp COMMIT = new BinaryProtocol.MessageOp(105, Commit.class);
    public static final BinaryProtocol.MessageOp ACK = new BinaryProtocol.MessageOp(106, Ack.class);
    public static final BinaryProtocol.MessageOp ENTRY_REQUEST = new BinaryProtocol.MessageOp(107, EntryRequest.class);
    public static final BinaryProtocol.MessageOp ENTRY_NOTFOUND = new BinaryProtocol.MessageOp(108, EntryNotFound.class);
    public static final BinaryProtocol.MessageOp ALT_MATCHPOINT = new BinaryProtocol.MessageOp(109, AlternateMatchpoint.class);
    public static final BinaryProtocol.MessageOp RESTORE_REQUEST = new BinaryProtocol.MessageOp(110, RestoreRequest.class);
    public static final BinaryProtocol.MessageOp RESTORE_RESPONSE = new BinaryProtocol.MessageOp(111, RestoreResponse.class);
    public static final BinaryProtocol.MessageOp SHUTDOWN_REQUEST = new BinaryProtocol.MessageOp(112, ShutdownRequest.class);
    public static final BinaryProtocol.MessageOp SHUTDOWN_RESPONSE = new BinaryProtocol.MessageOp(113, ShutdownResponse.class);
    public static final BinaryProtocol.MessageOp GROUP_ACK = new BinaryProtocol.MessageOp(114, GroupAck.class);
    protected int streamLogVersion;
    protected final LongStat nAckMessages;
    protected final LongStat nGroupAckMessages;
    protected final LongStat nGroupedAcks;
    protected final LongMaxStat nMaxGroupedAcks;
    protected final RepImpl repImpl;
    private boolean fixLogVersion12Entries = false;

    BaseProtocol(RepImpl repImpl, NameIdPair nameIdPair, int protocolVersion, int maxProtocolVersion, int streamLogVersion, BinaryProtocol.MessageOp[] protocolOps, boolean checkValidity) {
        super(nameIdPair, maxProtocolVersion, protocolVersion, repImpl);
        this.streamLogVersion = streamLogVersion;
        this.repImpl = repImpl;
        this.nAckMessages = new LongStat(this.stats, BinaryProtocolStatDefinition.N_ACK_MESSAGES);
        this.nGroupAckMessages = new LongStat(this.stats, BinaryProtocolStatDefinition.N_GROUP_ACK_MESSAGES);
        this.nGroupedAcks = new LongStat(this.stats, BinaryProtocolStatDefinition.N_GROUPED_ACKS);
        this.nMaxGroupedAcks = new LongMaxZeroStat(this.stats, BinaryProtocolStatDefinition.N_MAX_GROUPED_ACKS);
        this.initializeMessageOps(protocolOps, checkValidity);
    }

    protected BaseProtocol(RepImpl repImpl, NameIdPair nameIdPair, int protocolVersion, int maxProtocolVersion, int streamLogVersion, BinaryProtocol.MessageOp[] protocolOps) {
        this(repImpl, nameIdPair, protocolVersion, maxProtocolVersion, streamLogVersion, protocolOps, true);
    }

    public int getStreamLogVersion() {
        return this.streamLogVersion;
    }

    public void setStreamLogVersion(int streamLogVersion) {
        this.streamLogVersion = streamLogVersion;
    }

    public boolean getFixLogVersion12Entries() {
        return this.fixLogVersion12Entries;
    }

    public void setFixLogVersion12Entries(boolean value) {
        this.fixLogVersion12Entries = value;
    }

    protected void writeOutputWireRecord(OutputWireRecord record, ByteBuffer messageBuffer) {
        boolean changedFormat = record.writeToWire(messageBuffer, this.streamLogVersion);
        if (changedFormat) {
            this.nEntriesWrittenOldVersion.increment();
        }
    }

    private void initializeMessageOps(BinaryProtocol.MessageOp[] protocolOps, boolean checkValidity) {
        if (checkValidity) {
            for (BinaryProtocol.MessageOp op : protocolOps) {
                if (BaseProtocol.isValidMsgOpCode(op.getOpId())) continue;
                throw EnvironmentFailureException.unexpectedState("Op id: " + op.getOpId() + " is out of allowed range inclusively [" + 1024 + ", " + 2047 + "]");
            }
        }
        this.initializeMessageOps(protocolOps);
    }

    private static boolean getByteNeedsAck(byte needsAckByte) {
        switch (needsAckByte) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw EnvironmentFailureException.unexpectedState("Invalid bool ordinal: " + needsAckByte);
    }

    private static boolean isValidMsgOpCode(short opId) {
        return opId <= 2047 && opId >= 1024;
    }

    private static Durability.SyncPolicy getByteReplicaSyncPolicy(byte syncPolicyByte) {
        for (Durability.SyncPolicy p : Durability.SyncPolicy.values()) {
            if (p.ordinal() != syncPolicyByte) continue;
            return p;
        }
        throw EnvironmentFailureException.unexpectedState("Invalid sync policy ordinal: " + syncPolicyByte);
    }

    private void putLongArray(ByteBuffer buffer, long[] la) {
        LogUtils.writeInt(buffer, la.length);
        for (long l : la) {
            LogUtils.writeLong(buffer, l);
        }
    }

    private long[] readLongArray(ByteBuffer buffer) {
        long[] la = new long[LogUtils.readInt(buffer)];
        for (int i = 0; i < la.length; ++i) {
            la[i] = LogUtils.readLong(buffer);
        }
        return la;
    }

    protected abstract class ProtocolVersion
    extends HandshakeMessage {
        private final int version;
        private final NameIdPair nameIdPair;

        public ProtocolVersion(int version) {
            this.version = version;
            this.nameIdPair = BaseProtocol.this.nameIdPair;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.version, this.nameIdPair);
        }

        public ProtocolVersion(ByteBuffer buffer) {
            this.version = LogUtils.readInt(buffer);
            this.nameIdPair = this.getNameIdPair(buffer);
        }

        protected int getVersion() {
            return this.version;
        }

        protected NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }
    }

    protected abstract class HandshakeMessage
    extends BinaryProtocol.SimpleMessage {
        protected HandshakeMessage() {
            super(BaseProtocol.this);
        }
    }

    protected abstract class VLSNMessage
    extends BinaryProtocol.Message {
        protected final VLSN vlsn;

        VLSNMessage(VLSN vlsn) {
            super(BaseProtocol.this);
            this.vlsn = vlsn;
        }

        public VLSNMessage(ByteBuffer buffer) {
            super(BaseProtocol.this);
            long vlsnSequence = LogUtils.readLong(buffer);
            this.vlsn = new VLSN(vlsnSequence);
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = this.wireFormatSize();
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.vlsn.getSequence());
            messageBuffer.flip();
            return messageBuffer;
        }

        int wireFormatSize() {
            return 8;
        }

        VLSN getVLSN() {
            return this.vlsn;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.vlsn;
        }
    }

    public class GroupAck
    extends BinaryProtocol.Message {
        private final long[] txnIds;

        public GroupAck(long[] txnIds) {
            super(BaseProtocol.this);
            this.txnIds = txnIds;
            BaseProtocol.this.nGroupAckMessages.increment();
            BaseProtocol.this.nGroupedAcks.add(txnIds.length);
            BaseProtocol.this.nMaxGroupedAcks.setMax(txnIds.length);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return GROUP_ACK;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = 4 + 8 * this.txnIds.length;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            BaseProtocol.this.putLongArray(messageBuffer, this.txnIds);
            messageBuffer.flip();
            return messageBuffer;
        }

        public GroupAck(ByteBuffer buffer) {
            super(BaseProtocol.this);
            this.txnIds = BaseProtocol.this.readLongArray(buffer);
        }

        public long[] getTxnIds() {
            return this.txnIds;
        }

        @Override
        public String toString() {
            return super.toString() + " txn " + Arrays.toString(this.txnIds);
        }
    }

    public class ShutdownResponse
    extends BinaryProtocol.Message {
        public ShutdownResponse() {
            super(BaseProtocol.this);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return SHUTDOWN_RESPONSE;
        }

        public ShutdownResponse(ByteBuffer buffer) {
            super(BaseProtocol.this);
        }
    }

    public class ShutdownRequest
    extends BinaryProtocol.SimpleMessage {
        private final long shutdownTimeMs;

        public ShutdownRequest(long shutdownTimeMs) {
            super(BaseProtocol.this);
            this.shutdownTimeMs = shutdownTimeMs;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return SHUTDOWN_REQUEST;
        }

        public ShutdownRequest(ByteBuffer buffer) {
            super(BaseProtocol.this);
            this.shutdownTimeMs = LogUtils.readLong(buffer);
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.shutdownTimeMs);
        }

        public long getShutdownTimeMs() {
            return this.shutdownTimeMs;
        }
    }

    public class RestoreResponse
    extends BinaryProtocol.SimpleMessage {
        private final VLSN cbvlsn;
        private final RepNodeImpl[] logProviders;

        public RestoreResponse(VLSN cbvlsn, RepNodeImpl[] logProviders) {
            super(BaseProtocol.this);
            this.cbvlsn = cbvlsn;
            this.logProviders = logProviders;
        }

        public RestoreResponse(ByteBuffer buffer) {
            super(BaseProtocol.this);
            long vlsnSequence = LogUtils.readLong(buffer);
            this.cbvlsn = new VLSN(vlsnSequence);
            this.logProviders = this.getRepNodeImplArray(buffer);
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.cbvlsn.getSequence(), this.logProviders);
        }

        @Override
        protected void putWireFormat(ByteBuffer buffer, Object obj) {
            if (obj.getClass() == RepNodeImpl[].class) {
                this.putRepNodeImplArray(buffer, (RepNodeImpl[])obj);
            } else {
                super.putWireFormat(buffer, obj);
            }
        }

        @Override
        protected int wireFormatSize(Object obj) {
            if (obj.getClass() == RepNodeImpl[].class) {
                return this.getRepNodeImplArraySize((RepNodeImpl[])obj);
            }
            return super.wireFormatSize(obj);
        }

        private void putRepNodeImplArray(ByteBuffer buffer, RepNodeImpl[] ra) {
            LogUtils.writeInt(buffer, ra.length);
            int groupFormatVersion = this.getGroupFormatVersion();
            for (RepNodeImpl node : ra) {
                this.putByteArray(buffer, RepGroupImpl.serializeBytes(node, groupFormatVersion));
            }
        }

        private RepNodeImpl[] getRepNodeImplArray(ByteBuffer buffer) {
            RepNodeImpl[] ra = new RepNodeImpl[LogUtils.readInt(buffer)];
            int groupFormatVersion = this.getGroupFormatVersion();
            for (int i = 0; i < ra.length; ++i) {
                ra[i] = RepGroupImpl.deserializeNode(this.getByteArray(buffer), groupFormatVersion);
            }
            return ra;
        }

        private int getRepNodeImplArraySize(RepNodeImpl[] ra) {
            int size = 4;
            int groupFormatVersion = this.getGroupFormatVersion();
            for (RepNodeImpl node : ra) {
                size += 4 + RepGroupImpl.serializeBytes(node, groupFormatVersion).length;
            }
            return size;
        }

        private int getGroupFormatVersion() {
            return BaseProtocol.this.getVersion() < 5 ? 2 : 3;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return RESTORE_RESPONSE;
        }

        RepNodeImpl[] getLogProviders() {
            return this.logProviders;
        }

        VLSN getCBVLSN() {
            return this.cbvlsn;
        }
    }

    public class RestoreRequest
    extends VLSNMessage {
        RestoreRequest(VLSN failedMatchpoint) {
            super(failedMatchpoint);
        }

        public RestoreRequest(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return RESTORE_REQUEST;
        }
    }

    public class AlternateMatchpoint
    extends BinaryProtocol.Message {
        private final InputWireRecord alternateInput;
        private OutputWireRecord alternateOutput;

        AlternateMatchpoint(OutputWireRecord alternate) {
            super(BaseProtocol.this);
            this.alternateOutput = null;
            this.alternateInput = null;
            this.alternateOutput = alternate;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return ALT_MATCHPOINT;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = this.alternateOutput.getWireSize(BaseProtocol.this.streamLogVersion);
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            BaseProtocol.this.writeOutputWireRecord(this.alternateOutput, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        public AlternateMatchpoint(ByteBuffer buffer) throws DatabaseException {
            super(BaseProtocol.this);
            this.alternateOutput = null;
            this.alternateInput = new InputWireRecord(BaseProtocol.this.repImpl, buffer, BaseProtocol.this);
        }

        public InputWireRecord getAlternateWireRecord() {
            return this.alternateInput;
        }

        @Override
        public boolean match(BinaryProtocol.Message other) {
            if (this.alternateOutput == null) {
                this.alternateOutput = new OutputWireRecord((EnvironmentImpl)BaseProtocol.this.repImpl, this.alternateInput);
            }
            return super.match(other);
        }
    }

    public class EntryNotFound
    extends BinaryProtocol.Message {
        public EntryNotFound() {
            super(BaseProtocol.this);
        }

        public EntryNotFound(ByteBuffer buffer) {
            super(BaseProtocol.this);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return ENTRY_NOTFOUND;
        }
    }

    public static enum EntryRequestType {
        DEFAULT,
        AVAILABLE,
        NOW;

    }

    public class EntryRequest
    extends VLSNMessage {
        private final EntryRequestType type;

        EntryRequest(VLSN matchpoint) {
            super(matchpoint);
            this.type = EntryRequestType.DEFAULT;
        }

        EntryRequest(VLSN matchpoint, EntryRequestType type) {
            super(matchpoint);
            this.type = type;
        }

        public EntryRequest(ByteBuffer buffer) {
            super(buffer);
            if (BaseProtocol.this.getVersion() < 7) {
                this.type = EntryRequestType.DEFAULT;
                return;
            }
            int i = LogUtils.readInt(buffer);
            this.type = EntryRequestType.values()[i];
        }

        public EntryRequestType getType() {
            return this.type;
        }

        @Override
        public ByteBuffer wireFormat() {
            if (BaseProtocol.this.getVersion() < 7) {
                return super.wireFormat();
            }
            int bodySize = this.wireFormatSize();
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.vlsn.getSequence());
            LogUtils.writeInt(messageBuffer, this.type.ordinal());
            messageBuffer.flip();
            return messageBuffer;
        }

        @Override
        public int wireFormatSize() {
            if (BaseProtocol.this.getVersion() < 7) {
                return super.wireFormatSize();
            }
            return super.wireFormatSize() + 4;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return ENTRY_REQUEST;
        }

        @Override
        public String toString() {
            return "entry request vlsn: " + super.toString() + ", type: " + (Object)((Object)this.type);
        }
    }

    public class Ack
    extends BinaryProtocol.Message {
        private final long txnId;

        public Ack(long txnId) {
            super(BaseProtocol.this);
            this.txnId = txnId;
            BaseProtocol.this.nAckMessages.increment();
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return ACK;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = 8;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.txnId);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Ack(ByteBuffer buffer) {
            super(BaseProtocol.this);
            this.txnId = LogUtils.readLong(buffer);
        }

        public long getTxnId() {
            return this.txnId;
        }

        @Override
        public String toString() {
            return super.toString() + " txn " + this.txnId;
        }
    }

    public class Commit
    extends Entry {
        private final boolean needsAck;
        private final Durability.SyncPolicy replicaSyncPolicy;

        public Commit(boolean needsAck, Durability.SyncPolicy replicaSyncPolicy, OutputWireRecord wireRecord) {
            super(wireRecord);
            this.needsAck = needsAck;
            this.replicaSyncPolicy = replicaSyncPolicy;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return COMMIT;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = super.getWireSize() + 1 + 1;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            messageBuffer.put((byte)(this.needsAck ? 1 : 0));
            messageBuffer.put((byte)this.replicaSyncPolicy.ordinal());
            BaseProtocol.this.writeOutputWireRecord(this.outputWireRecord, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Commit(ByteBuffer buffer) throws DatabaseException {
            this(BaseProtocol.getByteNeedsAck(buffer.get()), BaseProtocol.getByteReplicaSyncPolicy(buffer.get()), buffer);
        }

        private Commit(boolean needsAck, Durability.SyncPolicy replicaSyncPolicy, ByteBuffer buffer) throws DatabaseException {
            super(buffer);
            this.needsAck = needsAck;
            this.replicaSyncPolicy = replicaSyncPolicy;
        }

        public boolean getNeedsAck() {
            return this.needsAck;
        }

        public Durability.SyncPolicy getReplicaSyncPolicy() {
            return this.replicaSyncPolicy;
        }
    }

    public class HeartbeatResponse
    extends BinaryProtocol.Message {
        private final VLSN syncupVLSN;
        private final VLSN txnEndVLSN;

        public HeartbeatResponse(VLSN syncupVLSN, VLSN ackedVLSN) {
            super(BaseProtocol.this);
            this.syncupVLSN = syncupVLSN;
            this.txnEndVLSN = ackedVLSN;
        }

        public HeartbeatResponse(ByteBuffer buffer) {
            super(BaseProtocol.this);
            this.syncupVLSN = new VLSN(LogUtils.readLong(buffer));
            this.txnEndVLSN = BaseProtocol.this.getVersion() >= 4 ? new VLSN(LogUtils.readLong(buffer)) : null;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return HEARTBEAT_RESPONSE;
        }

        @Override
        public ByteBuffer wireFormat() {
            boolean includeTxnEndVLSN = BaseProtocol.this.getVersion() >= 4;
            int bodySize = includeTxnEndVLSN ? 16 : 8;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.syncupVLSN.getSequence());
            if (includeTxnEndVLSN) {
                LogUtils.writeLong(messageBuffer, this.txnEndVLSN.getSequence());
            }
            messageBuffer.flip();
            return messageBuffer;
        }

        public VLSN getSyncupVLSN() {
            return this.syncupVLSN;
        }

        public VLSN getTxnEndVLSN() {
            return this.txnEndVLSN;
        }

        @Override
        public String toString() {
            return super.toString() + " txnEndVLSN=" + this.txnEndVLSN + " syncupVLSN=" + this.syncupVLSN;
        }
    }

    public class Heartbeat
    extends BinaryProtocol.Message {
        private final long masterNow;
        private final long currentTxnEndVLSN;

        public Heartbeat(long masterNow, long currentTxnEndVLSN) {
            super(BaseProtocol.this);
            this.masterNow = masterNow;
            this.currentTxnEndVLSN = currentTxnEndVLSN;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return HEARTBEAT;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = 16;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.masterNow);
            LogUtils.writeLong(messageBuffer, this.currentTxnEndVLSN);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Heartbeat(ByteBuffer buffer) {
            super(BaseProtocol.this);
            this.masterNow = LogUtils.readLong(buffer);
            this.currentTxnEndVLSN = LogUtils.readLong(buffer);
        }

        public long getMasterNow() {
            return this.masterNow;
        }

        public long getCurrentTxnEndVLSN() {
            return this.currentTxnEndVLSN;
        }

        @Override
        public String toString() {
            return super.toString() + " masterNow=" + this.masterNow + " currentCommit=" + this.currentTxnEndVLSN;
        }
    }

    public class StartStream
    extends VLSNMessage {
        private final FeederFilter feederFilter;

        StartStream(VLSN startVLSN) {
            super(startVLSN);
            this.feederFilter = null;
        }

        StartStream(VLSN startVLSN, FeederFilter filter) {
            super(startVLSN);
            this.feederFilter = filter;
        }

        public StartStream(ByteBuffer buffer) {
            super(buffer);
            if (BaseProtocol.this.getVersion() < 6) {
                this.feederFilter = null;
                return;
            }
            int length = LogUtils.readInt(buffer);
            if (length == 0) {
                this.feederFilter = null;
                return;
            }
            byte[] filterBytes = LogUtils.readBytesNoLength(buffer, length);
            ByteArrayInputStream bais = new ByteArrayInputStream(filterBytes);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                this.feederFilter = (FeederFilter)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                BaseProtocol.this.logger.warning(e.getLocalizedMessage());
                throw new IllegalStateException(e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        BaseProtocol.this.logger.finest("exception raised when closing the object input stream object " + e.getLocalizedMessage());
                    }
                }
            }
        }

        public FeederFilter getFeederFilter() {
            return this.feederFilter;
        }

        @Override
        public ByteBuffer wireFormat() {
            int feederBufferSize;
            byte[] filterBytes;
            if (BaseProtocol.this.getVersion() < 6) {
                return super.wireFormat();
            }
            if (this.feederFilter != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(this.feederFilter);
                    oos.flush();
                }
                catch (IOException e) {
                    BaseProtocol.this.logger.warning(e.getLocalizedMessage());
                    throw new IllegalStateException(e);
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException e) {
                            BaseProtocol.this.logger.finest("exception raised when closing the object output stream object " + e.getLocalizedMessage());
                        }
                    }
                }
                filterBytes = baos.toByteArray();
                feederBufferSize = filterBytes.length;
            } else {
                filterBytes = null;
                feederBufferSize = 0;
            }
            int bodySize = this.wireFormatSize() + 4 + feederBufferSize;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.vlsn.getSequence());
            LogUtils.writeInt(messageBuffer, feederBufferSize);
            if (feederBufferSize > 0) {
                LogUtils.writeBytesNoLength(messageBuffer, filterBytes);
            }
            messageBuffer.flip();
            return messageBuffer;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return START_STREAM;
        }

        @Override
        public String toString() {
            String filterString = this.feederFilter == null ? "[no filtering]" : this.feederFilter.toString();
            return super.toString() + " " + filterString;
        }
    }

    public class Entry
    extends BinaryProtocol.Message {
        protected final InputWireRecord inputWireRecord;
        protected OutputWireRecord outputWireRecord;

        public Entry(OutputWireRecord outputWireRecord) {
            super(BaseProtocol.this);
            this.inputWireRecord = null;
            this.outputWireRecord = outputWireRecord;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return ENTRY;
        }

        @Override
        public ByteBuffer wireFormat() {
            int bodySize = this.getWireSize();
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            BaseProtocol.this.writeOutputWireRecord(this.outputWireRecord, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        protected int getWireSize() {
            return this.outputWireRecord.getWireSize(BaseProtocol.this.streamLogVersion);
        }

        public Entry(ByteBuffer buffer) throws DatabaseException {
            super(BaseProtocol.this);
            this.inputWireRecord = new InputWireRecord(BaseProtocol.this.repImpl, buffer, BaseProtocol.this);
        }

        public InputWireRecord getWireRecord() {
            return this.inputWireRecord;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.inputWireRecord != null) {
                sb.append(" ");
                sb.append(this.inputWireRecord);
            }
            if (this.outputWireRecord != null) {
                sb.append(" ");
                sb.append(this.outputWireRecord);
            }
            return sb.toString();
        }

        @Override
        public boolean match(BinaryProtocol.Message other) {
            if (this.outputWireRecord == null) {
                this.outputWireRecord = new OutputWireRecord((EnvironmentImpl)BaseProtocol.this.repImpl, this.inputWireRecord);
            }
            return super.match(other);
        }

        public boolean isTxnEnd() {
            byte entryType = this.getWireRecord().getEntryType();
            return LogEntryType.LOG_TXN_COMMIT.equalsType(entryType) || LogEntryType.LOG_TXN_ABORT.equalsType(entryType);
        }
    }
}

