/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.util.concurrent.atomic.AtomicLong;

public class LongAvg
extends MapStatComponent<Long, LongAvg> {
    private static final long serialVersionUID = 1L;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong total = new AtomicLong();

    public LongAvg() {
    }

    private LongAvg(LongAvg other) {
        this.count.set(other.count.get());
        this.total.set(other.total.get());
    }

    public void add(long value) {
        this.count.incrementAndGet();
        this.total.addAndGet(value);
    }

    public void add(LongAvg other) {
        this.count.addAndGet(other.count.get());
        this.total.addAndGet(other.total.get());
    }

    public void updateInterval(LongAvg other) {
        this.count.addAndGet(-other.count.get());
        this.total.addAndGet(-other.total.get());
    }

    public void negate() {
        this.count.set(-this.count.get());
        this.total.set(-this.total.get());
    }

    @Override
    protected String getFormattedValue(boolean useCommas) {
        if (this.isNotSet()) {
            return "unknown";
        }
        long value = this.get();
        return useCommas ? FormatUtil.decimalScale0().format(value) : Long.toString(value);
    }

    @Override
    public LongAvg copy() {
        return new LongAvg(this);
    }

    @Override
    public Long get() {
        long cnt = this.count.get();
        if (cnt == 0L) {
            return 0L;
        }
        return this.total.get() / cnt;
    }

    @Override
    public void clear() {
        this.count.set(0L);
        this.total.set(0L);
    }

    @Override
    public boolean isNotSet() {
        return this.count.get() == 0L;
    }

    public String toString() {
        return "LongAvg[count=" + this.count + " total=" + this.total + "]";
    }
}

